/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.util;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ByteStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;

public class InMemoryByteStream
implements ByteStream {
    private final byte[] data;

    public InMemoryByteStream(byte[] data) {
        this.data = data;
    }

    public byte[] read(BigInteger offset, int length) throws IOException {
        if (!this.isAvailable(offset, length)) {
            throw new IOException("Data to read is not available.");
        }
        byte[] data = new byte[length];
        System.arraycopy(this.data, offset.intValueExact(), data, 0, length);
        return data;
    }

    public boolean isAvailable(BigInteger offset, int length) {
        return offset.intValueExact() + length <= this.data.length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.data.length + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass((Object)this, (Object)obj) && Arrays.equals(this.data, ((InMemoryByteStream)obj).data);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), Arrays.hashCode(this.data));
    }
}

