/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.Assert;

public class ClassDefinition {
    public static void checkUtilityClass(Class<?> utilityClass) throws ReflectiveOperationException {
        String simpleName = utilityClass.getSimpleName();
        Assert.assertTrue((String)(simpleName + " should be final"), (boolean)Modifier.isFinal(utilityClass.getModifiers()));
        Constructor<?>[] constructors = utilityClass.getDeclaredConstructors();
        Assert.assertEquals((String)(simpleName + " should have exactly 1 constructor"), (long)1L, (long)constructors.length);
        Assert.assertTrue((String)(simpleName + " should have a private constructor"), (boolean)Modifier.isPrivate(constructors[0].getModifiers()));
        constructors[0].setAccessible(true);
        constructors[0].newInstance(new Object[0]);
        for (Method method : utilityClass.getDeclaredMethods()) {
            Assert.assertTrue((String)("method '" + method.getName() + "' in " + simpleName + " should be static"), (boolean)Modifier.isStatic(method.getModifiers()));
        }
    }
}

