/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.util;

import io.parsingdata.metal.data.ByteStream;
import java.io.IOException;

public class InMemoryByteStream
implements ByteStream {
    private final byte[] _data;

    public InMemoryByteStream(byte[] data) {
        this._data = data;
    }

    public int read(long offset, byte[] data) throws IOException {
        if (offset >= (long)this._data.length) {
            return 0;
        }
        int toCopy = (int)offset + data.length > this._data.length ? this._data.length - (int)offset : data.length;
        System.arraycopy(this._data, (int)offset, data, 0, toCopy);
        return toCopy;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._data.length + ")";
    }
}

