/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.token;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ParseRef;
import io.parsingdata.metal.data.ParseResult;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.OptionalValue;
import io.parsingdata.metal.expression.value.ValueExpression;
import io.parsingdata.metal.token.Token;
import java.io.IOException;

public class Sub
extends Token {
    private final Token _op;
    private final ValueExpression _addr;

    public Sub(Token op, ValueExpression addr, Encoding enc) {
        super(enc);
        this._op = Util.checkNotNull(op, "op");
        this._addr = Util.checkNotNull(addr, "addr");
    }

    @Override
    protected ParseResult parseImpl(String scope, Environment env, Encoding enc) throws IOException {
        OptionalValue ov = this._addr.eval(env, enc);
        if (!ov.isPresent()) {
            return new ParseResult(false, env);
        }
        long ref = ov.get().asNumeric().longValue();
        if (env.order.hasGraphAtRef(ref)) {
            return new ParseResult(true, new Environment(env.order.add(new ParseRef(ref, this)), env.input, env.offset));
        }
        ParseResult res = this._op.parse(scope, new Environment(env.order.addBranch(this), env.input, ref), enc);
        if (res.succeeded()) {
            return new ParseResult(true, new Environment(res.getEnvironment().order.closeBranch(), res.getEnvironment().input, env.offset));
        }
        return new ParseResult(false, env);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._op + ", " + this._addr + ")";
    }
}

