/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.token;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ParseResult;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.token.Token;
import java.io.IOException;

public class Seq
extends Token {
    private final Token[] _tokens;

    public Seq(Encoding enc, Token ... tokens) {
        super(enc);
        this._tokens = Util.checkContainsNoNulls(tokens, "tokens");
        if (tokens.length < 2) {
            throw new IllegalArgumentException("At least two Tokens are required.");
        }
    }

    @Override
    protected ParseResult parseImpl(String scope, Environment env, Encoding enc) throws IOException {
        ParseResult res = this.iterate(scope, new Environment(env.order.addBranch(this), env.input, env.offset), enc, 0);
        if (res.succeeded()) {
            return new ParseResult(true, new Environment(res.getEnvironment().order.closeBranch(), res.getEnvironment().input, res.getEnvironment().offset));
        }
        return new ParseResult(false, env);
    }

    private ParseResult iterate(String scope, Environment env, Encoding enc, int index) throws IOException {
        if (index >= this._tokens.length) {
            return new ParseResult(true, env);
        }
        ParseResult res = this._tokens[index].parse(scope, env, enc);
        if (res.succeeded()) {
            return this.iterate(scope, res.getEnvironment(), enc, index + 1);
        }
        return res;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + Util.tokensToString(this._tokens) + ")";
    }
}

