/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.token;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ParseResult;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.OptionalValue;
import io.parsingdata.metal.expression.value.ValueExpression;
import io.parsingdata.metal.token.Token;
import java.io.IOException;

public class RepN
extends Token {
    private final Token _op;
    private final ValueExpression _n;

    public RepN(Token op, ValueExpression n, Encoding enc) {
        super(enc);
        this._op = Util.checkNotNull(op, "op");
        this._n = Util.checkNotNull(n, "n");
    }

    @Override
    protected ParseResult parseImpl(String scope, Environment env, Encoding enc) throws IOException {
        OptionalValue count = this._n.eval(env, enc);
        if (!count.isPresent()) {
            return new ParseResult(false, env);
        }
        ParseResult res = this.iterate(scope, new Environment(env.order.addBranch(this), env.input, env.offset), enc, count.get().asNumeric().longValue());
        if (res.succeeded()) {
            return new ParseResult(true, new Environment(res.getEnvironment().order.closeBranch(), res.getEnvironment().input, res.getEnvironment().offset));
        }
        return new ParseResult(false, env);
    }

    private ParseResult iterate(String scope, Environment env, Encoding enc, long count) throws IOException {
        if (count <= 0L) {
            return new ParseResult(true, env);
        }
        ParseResult res = this._op.parse(scope, env, enc);
        if (res.succeeded()) {
            return this.iterate(scope, res.getEnvironment(), enc, count - 1L);
        }
        return new ParseResult(false, env);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._op + "," + this._n + ")";
    }
}

