/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.token;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ParseResult;
import io.parsingdata.metal.data.ParseValue;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.Expression;
import io.parsingdata.metal.expression.True;
import io.parsingdata.metal.expression.value.OptionalValue;
import io.parsingdata.metal.expression.value.ValueExpression;
import io.parsingdata.metal.token.Token;
import java.io.IOException;

public class Def
extends Token {
    private final String _name;
    private final ValueExpression _size;
    private final Expression _pred;

    public Def(String name, ValueExpression size, Expression pred, Encoding enc) {
        super(enc);
        this._name = Util.checkNotNull(name, "name");
        this._size = Util.checkNotNull(size, "size");
        this._pred = pred == null ? new True() : pred;
    }

    @Override
    protected ParseResult parseImpl(String scope, Environment env, Encoding enc) throws IOException {
        OptionalValue size = this._size.eval(env, enc);
        if (!size.isPresent()) {
            return new ParseResult(false, env);
        }
        int dataSize = size.get().asNumeric().intValue();
        if (dataSize < 0) {
            return new ParseResult(false, env);
        }
        byte[] data = new byte[dataSize];
        if (env.input.read(env.offset, data) != data.length) {
            return new ParseResult(false, env);
        }
        Environment newEnv = new Environment(env.order.add(new ParseValue(scope, this._name, this, env.offset, data, enc)), env.input, env.offset + (long)size.get().asNumeric().intValue());
        return this._pred.eval(newEnv, enc) ? new ParseResult(true, newEnv) : new ParseResult(false, env);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(\"" + this._name + "\"," + this._size + "," + this._pred + ",)";
    }
}

