/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value.bitwise;

import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.BinaryValueExpression;
import io.parsingdata.metal.expression.value.ConstantFactory;
import io.parsingdata.metal.expression.value.OptionalValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.util.BitSet;

public class ShiftLeft
extends BinaryValueExpression {
    public ShiftLeft(ValueExpression lop, ValueExpression rop) {
        super(lop, rop);
    }

    @Override
    public OptionalValue eval(Value lv, Value rv, Environment env, Encoding enc) {
        BitSet lbs = lv.asBitSet();
        int shiftLeft = rv.asNumeric().intValue();
        int bitCount = lbs.length() + shiftLeft;
        BitSet out = new BitSet(bitCount);
        int i = lbs.nextSetBit(0);
        while (i >= 0) {
            out.set(i + shiftLeft);
            i = lbs.nextSetBit(i + 1);
        }
        int minSize = (bitCount + 7) / 8;
        return OptionalValue.of(ConstantFactory.createFromBitSet(out, minSize, enc));
    }
}

