/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.encoding.ByteOrder;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.OptionalValue;
import io.parsingdata.metal.expression.value.ValueOperation;
import java.math.BigInteger;
import java.util.BitSet;

public class Value {
    private final byte[] _data;
    private final Encoding _enc;

    public Value(byte[] data, Encoding enc) {
        this._data = (byte[])data.clone();
        this._enc = Util.checkNotNull(enc, "enc");
    }

    public byte[] getValue() {
        return (byte[])this._data.clone();
    }

    public BigInteger asNumeric() {
        return this._enc.isSigned() ? new BigInteger(this._enc.getByteOrder().apply(this._data)) : new BigInteger(1, this._enc.getByteOrder().apply(this._data));
    }

    public String asString() {
        return new String(this._data, this._enc.getCharset());
    }

    public BitSet asBitSet() {
        return BitSet.valueOf(this._enc.getByteOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN.apply(this._data) : this._data);
    }

    public Encoding getEncoding() {
        return this._enc;
    }

    public OptionalValue operation(ValueOperation op) {
        return op.execute(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + Util.bytesToHexString(this._data) + ")";
    }
}

