/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.Shorthand;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ParseValueList;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.OptionalValue;
import io.parsingdata.metal.expression.value.Reducer;
import io.parsingdata.metal.expression.value.ValueExpression;

public class FoldLeft
implements ValueExpression {
    private final String _name;
    private final Reducer _reducer;
    private final ValueExpression _init;

    public FoldLeft(String name, Reducer reducer, ValueExpression init) {
        this._name = Util.checkNotNull(name, "name");
        this._reducer = Util.checkNotNull(reducer, "reducer");
        this._init = init;
    }

    @Override
    public OptionalValue eval(Environment env, Encoding enc) {
        OptionalValue init = this._init != null ? this._init.eval(env, enc) : OptionalValue.empty();
        ParseValueList values = env.order.getAll(this._name).reverse();
        if (values.isEmpty()) {
            return init;
        }
        if (init.isPresent()) {
            return this.fold(env, enc, this._reducer, init, values);
        }
        return this.fold(env, enc, this._reducer, OptionalValue.of(values.head), values.tail);
    }

    private OptionalValue fold(Environment env, Encoding enc, Reducer reducer, OptionalValue head, ParseValueList tail) {
        if (!head.isPresent() || tail.isEmpty()) {
            return head;
        }
        return this.fold(env, enc, reducer, reducer.reduce(Shorthand.con(head.get()), Shorthand.con(tail.head)).eval(env, enc), tail.tail);
    }
}

