/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.encoding.ByteOrder;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.Value;
import java.math.BigInteger;
import java.util.BitSet;

public class ConstantFactory {
    public static Value createFromNumeric(BigInteger value, Encoding enc) {
        return new Value(ConstantFactory.compact(value.toByteArray(), enc.isSigned()), ConstantFactory.setToBE(enc));
    }

    public static Value createFromNumeric(long value, Encoding enc) {
        return ConstantFactory.createFromNumeric(BigInteger.valueOf(value), enc);
    }

    public static Value createFromString(String value, Encoding enc) {
        return new Value(value.getBytes(enc.getCharset()), enc);
    }

    public static Value createFromBitSet(BitSet value, int minSize, Encoding enc) {
        byte[] bytes = ByteOrder.LITTLE_ENDIAN.apply(value.toByteArray());
        byte[] out = new byte[Math.max(minSize, bytes.length)];
        System.arraycopy(bytes, 0, out, out.length - bytes.length, bytes.length);
        return new Value(out, ConstantFactory.setToBE(enc));
    }

    private static Encoding setToBE(Encoding enc) {
        return new Encoding(enc.isSigned(), enc.getCharset(), ByteOrder.BIG_ENDIAN);
    }

    private static byte[] compact(byte[] in, boolean signed) {
        int i;
        if (signed) {
            return in;
        }
        if (in.length < 2) {
            return in;
        }
        for (i = 0; i < in.length && in[i] == 0; ++i) {
        }
        byte[] out = new byte[in.length - i];
        System.arraycopy(in, i, out, 0, out.length);
        return out;
    }
}

