/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.OptionalValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;

public abstract class BinaryValueExpression
implements ValueExpression {
    private final ValueExpression _lop;
    private final ValueExpression _rop;

    public BinaryValueExpression(ValueExpression lop, ValueExpression rop) {
        this._lop = Util.checkNotNull(lop, "lop");
        this._rop = Util.checkNotNull(rop, "rop");
    }

    @Override
    public OptionalValue eval(Environment env, Encoding enc) {
        OptionalValue lv = this._lop.eval(env, enc);
        if (!lv.isPresent()) {
            return lv;
        }
        OptionalValue rv = this._rop.eval(env, enc);
        if (!rv.isPresent()) {
            return rv;
        }
        return this.eval(lv.get(), rv.get(), env, enc);
    }

    public abstract OptionalValue eval(Value var1, Value var2, Environment var3, Encoding var4);

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._lop + "," + this._rop + ")";
    }
}

