/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.comparison;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.Expression;
import io.parsingdata.metal.expression.value.OptionalValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;

public abstract class ComparisonExpression
implements Expression {
    private final ValueExpression _current;
    private final ValueExpression _predicate;

    public ComparisonExpression(ValueExpression current, ValueExpression predicate) {
        this._current = current;
        this._predicate = Util.checkNotNull(predicate, "predicate");
    }

    @Override
    public boolean eval(Environment env, Encoding enc) {
        OptionalValue ocv;
        OptionalValue optionalValue = ocv = this._current == null ? OptionalValue.of(env.order.current()) : this._current.eval(env, enc);
        if (!ocv.isPresent()) {
            return false;
        }
        OptionalValue opv = this._predicate.eval(env, enc);
        if (!opv.isPresent()) {
            return false;
        }
        return this.compare(ocv.get(), opv.get());
    }

    public abstract boolean compare(Value var1, Value var2);

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (this._current == null ? "" : this._current + ",") + this._predicate + ")";
    }
}

