/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.encoding;

import io.parsingdata.metal.encoding.ByteOrder;
import java.nio.charset.Charset;

public class Encoding {
    private static final boolean DEFAULT_SIGNED = false;
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO646-US");
    private static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private final boolean _signed;
    private final Charset _charset;
    private final ByteOrder _byteOrder;

    public Encoding() {
        this(false, DEFAULT_CHARSET, DEFAULT_BYTE_ORDER);
    }

    public Encoding(boolean signed) {
        this(signed, DEFAULT_CHARSET, DEFAULT_BYTE_ORDER);
    }

    public Encoding(Charset charset) {
        this(false, charset, DEFAULT_BYTE_ORDER);
    }

    public Encoding(ByteOrder byteOrder) {
        this(false, DEFAULT_CHARSET, byteOrder);
    }

    public Encoding(boolean signed, Charset charset, ByteOrder byteOrder) {
        this._signed = signed;
        this._charset = charset;
        this._byteOrder = byteOrder;
    }

    public boolean isSigned() {
        return this._signed;
    }

    public Charset getCharset() {
        return this._charset;
    }

    public ByteOrder getByteOrder() {
        return this._byteOrder;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (this._signed ? "SIGNED" : "UNSIGNED") + "," + this._charset + "," + (Object)((Object)this._byteOrder) + ")";
    }
}

