/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data.selection;

import io.parsingdata.metal.data.ParseGraph;
import io.parsingdata.metal.data.ParseItem;
import io.parsingdata.metal.data.ParseItemList;
import io.parsingdata.metal.token.Token;

public class ByToken {
    private ByToken() {
    }

    public static ParseItem get(ParseGraph graph, Token definition) {
        ParseItem item;
        if (definition == null) {
            throw new IllegalArgumentException("Argument definition may not be null.");
        }
        if (graph.definition == definition) {
            return graph;
        }
        if (graph.isEmpty()) {
            return null;
        }
        ParseItem head = graph.head;
        if (head.isValue() && head.asValue().definition == definition) {
            return head;
        }
        if (head.isGraph() && (item = ByToken.get(head.asGraph(), definition)) != null) {
            return item;
        }
        return ByToken.get(graph.tail, definition);
    }

    public static ParseItemList getAll(ParseGraph graph, Token definition) {
        if (definition == null) {
            throw new IllegalArgumentException("Argument definition may not be null.");
        }
        return ByToken.getAllRecursive(graph, definition);
    }

    private static ParseItemList getAllRecursive(ParseGraph graph, Token definition) {
        if (graph.isEmpty()) {
            return ParseItemList.EMPTY;
        }
        ParseItemList tailResults = ByToken.getAllRecursive(graph.tail, definition);
        ParseItemList results = graph.definition == definition ? tailResults.add(graph) : tailResults;
        ParseItem head = graph.head;
        if (head.isValue() && head.asValue().definition == definition) {
            return results.add(head);
        }
        if (head.isGraph()) {
            return results.add(ByToken.getAllRecursive(head.asGraph(), definition));
        }
        return results;
    }
}

