/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data.selection;

import io.parsingdata.metal.data.ParseGraph;
import io.parsingdata.metal.data.ParseGraphList;
import io.parsingdata.metal.data.ParseItem;
import io.parsingdata.metal.data.ParseValue;
import io.parsingdata.metal.data.selection.ByType;

public class ByOffset {
    public static boolean hasGraphAtRef(ParseGraph graph, long ref) {
        return ByOffset.findRef(ByType.getGraphs(graph), ref) != null;
    }

    public static ParseGraph findRef(ParseGraphList graphs, long ref) {
        if (graphs.isEmpty()) {
            return null;
        }
        ParseGraph res = ByOffset.findRef(graphs.tail, ref);
        if (res != null) {
            return res;
        }
        if (graphs.head.containsValue() && graphs.head.getLowestOffsetValue().getOffset() == ref) {
            return graphs.head;
        }
        return null;
    }

    public static ParseValue getLowestOffsetValue(ParseGraph graph) {
        if (!graph.containsValue()) {
            throw new IllegalStateException("Cannot determine lowest offset if graph does not contain a value.");
        }
        ParseItem head = graph.head;
        if (head.isValue()) {
            return ByOffset.getLowestOffsetValue(graph.tail, head.asValue());
        }
        return ByOffset.getLowestOffsetValue(graph.tail);
    }

    private static ParseValue getLowestOffsetValue(ParseGraph graph, ParseValue lowest) {
        if (!graph.containsValue()) {
            return lowest;
        }
        ParseItem head = graph.head;
        if (head.isValue()) {
            return ByOffset.getLowestOffsetValue(graph.tail, lowest.getOffset() < head.asValue().getOffset() ? lowest : head.asValue());
        }
        return ByOffset.getLowestOffsetValue(graph.tail, lowest);
    }
}

