/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ParseValue;

public class ParseValueList {
    public final ParseValue head;
    public final ParseValueList tail;
    public final long size;
    public static final ParseValueList EMPTY = new ParseValueList();

    private ParseValueList() {
        this.head = null;
        this.tail = null;
        this.size = 0L;
    }

    private ParseValueList(ParseValue head, ParseValueList tail) {
        this.head = Util.checkNotNull(head, "head");
        this.tail = Util.checkNotNull(tail, "tail");
        this.size = tail.size + 1L;
    }

    public static ParseValueList create(ParseValue head) {
        return EMPTY.add(Util.checkNotNull(head, "head"));
    }

    public ParseValueList add(ParseValue head) {
        return new ParseValueList(Util.checkNotNull(head, "head"), this);
    }

    public ParseValueList add(ParseValueList list) {
        Util.checkNotNull(list, "list");
        if (list.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return list;
        }
        return this.add(list.tail).add(list.head);
    }

    public ParseValue get(String name) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.head.matches(name)) {
            return this.head;
        }
        return this.tail.get(name);
    }

    public ParseValueList getAll(String name) {
        if (this.isEmpty()) {
            return this;
        }
        ParseValueList t = this.tail.getAll(name);
        if (this.head.matches(name)) {
            return t.add(this.head);
        }
        return t;
    }

    public ParseValueList getValuesSincePrefix(ParseValue prefix) {
        if (this.isEmpty()) {
            return this;
        }
        if (this.head == prefix) {
            return EMPTY;
        }
        ParseValueList t = this.tail.getValuesSincePrefix(prefix);
        return t.add(this.head);
    }

    public ParseValue current() {
        return this.head;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public ParseValue getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.tail.isEmpty()) {
            return this.head;
        }
        return this.tail.getFirst();
    }

    public boolean containsOffset(long offset) {
        if (this.isEmpty()) {
            return false;
        }
        if (this.head.getOffset() == offset) {
            return true;
        }
        return this.tail.containsOffset(offset);
    }

    public ParseValueList reverse() {
        if (this.isEmpty()) {
            return this;
        }
        return this.reverse(this.tail, ParseValueList.create(this.head));
    }

    private ParseValueList reverse(ParseValueList oldList, ParseValueList newList) {
        if (oldList.isEmpty()) {
            return newList;
        }
        return this.reverse(oldList.tail, newList.add(oldList.head));
    }

    public String toString() {
        return this.isEmpty() ? "" : ">" + this.head + this.tail.toString();
    }
}

