/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ParseGraph;
import io.parsingdata.metal.data.ParseItem;
import io.parsingdata.metal.data.ParseRef;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.token.Token;

public class ParseValue
extends Value
implements ParseItem {
    public static final String SEPARATOR = ".";
    public final String scope;
    public final String name;
    public Token definition;
    public final long offset;

    public ParseValue(String scope, String name, Token definition, long offset, byte[] data, Encoding enc) {
        super(data, enc);
        this.scope = Util.checkNotNull(scope, "scope");
        this.name = Util.checkNotNull(name, "name");
        this.definition = Util.checkNotNull(definition, "definition");
        this.offset = offset;
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.getScope() + SEPARATOR + this.getName();
    }

    public boolean matches(String name) {
        return this.getFullName().equals(name) || this.getFullName().endsWith(SEPARATOR + name);
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public boolean isGraph() {
        return false;
    }

    @Override
    public boolean isRef() {
        return false;
    }

    @Override
    public ParseValue asValue() {
        return this;
    }

    @Override
    public ParseGraph asGraph() {
        throw new UnsupportedOperationException("Cannot convert ParseValue to ParseGraph.");
    }

    @Override
    public ParseRef asRef() {
        throw new UnsupportedOperationException("Cannot convert ParseValue to ParseRef.");
    }

    @Override
    public Token getDefinition() {
        return this.definition;
    }

    @Override
    public String toString() {
        return "ParseValue(" + this.getName() + ":" + super.toString() + ")";
    }
}

