/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ParseGraph;
import io.parsingdata.metal.data.ParseGraphList;
import io.parsingdata.metal.data.ParseItem;
import io.parsingdata.metal.data.ParseValue;
import io.parsingdata.metal.data.selection.ByOffset;
import io.parsingdata.metal.token.Token;

public class ParseRef
implements ParseItem {
    public final long location;
    public final Token definition;

    public ParseRef(long location, Token definition) {
        this.location = location;
        this.definition = Util.checkNotNull(definition, "definition");
    }

    public ParseGraph resolve(ParseGraph root) {
        return ByOffset.findRef(ParseGraphList.create(root).add(root.getGraphs()), this.location);
    }

    @Override
    public boolean isValue() {
        return false;
    }

    @Override
    public boolean isGraph() {
        return false;
    }

    @Override
    public boolean isRef() {
        return true;
    }

    @Override
    public ParseValue asValue() {
        throw new UnsupportedOperationException("Cannot convert ParseRef to ParseValue.");
    }

    @Override
    public ParseGraph asGraph() {
        throw new UnsupportedOperationException("Cannot convert ParseRef to ParseGraph.");
    }

    @Override
    public ParseRef asRef() {
        return this;
    }

    @Override
    public Token getDefinition() {
        return this.definition;
    }

    public String toString() {
        return "ParseRef(" + this.location + ")";
    }
}

