/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ParseItem;

public class ParseItemList {
    public final ParseItem head;
    public final ParseItemList tail;
    public final long size;
    public static final ParseItemList EMPTY = new ParseItemList();

    private ParseItemList() {
        this.head = null;
        this.tail = null;
        this.size = 0L;
    }

    private ParseItemList(ParseItem head, ParseItemList tail) {
        this.head = Util.checkNotNull(head, "head");
        this.tail = Util.checkNotNull(tail, "tail");
        this.size = tail.size + 1L;
    }

    public static ParseItemList create(ParseItem head) {
        return EMPTY.add(Util.checkNotNull(head, "head"));
    }

    public ParseItemList add(ParseItem head) {
        return new ParseItemList(Util.checkNotNull(head, "head"), this);
    }

    public ParseItemList add(ParseItemList list) {
        Util.checkNotNull(list, "list");
        if (list.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return list;
        }
        return this.add(list.tail).add(list.head);
    }

    public ParseItem current() {
        return this.head;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public ParseItem getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.tail.isEmpty()) {
            return this.head;
        }
        return this.tail.getFirst();
    }

    public ParseItemList reverse() {
        if (this.isEmpty()) {
            return this;
        }
        return this.reverse(this.tail, ParseItemList.create(this.head));
    }

    private ParseItemList reverse(ParseItemList oldList, ParseItemList newList) {
        if (oldList.isEmpty()) {
            return newList;
        }
        return this.reverse(oldList.tail, newList.add(oldList.head));
    }

    public String toString() {
        return this.isEmpty() ? "" : ">" + this.head + this.tail.toString();
    }
}

