/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ParseGraph;

public class ParseGraphList {
    public final ParseGraph head;
    public final ParseGraphList tail;
    public final long size;
    public static final ParseGraphList EMPTY = new ParseGraphList();

    private ParseGraphList() {
        this.head = null;
        this.tail = null;
        this.size = 0L;
    }

    private ParseGraphList(ParseGraph head, ParseGraphList tail) {
        this.head = Util.checkNotNull(head, "head");
        this.tail = Util.checkNotNull(tail, "tail");
        this.size = tail.size + 1L;
    }

    public static ParseGraphList create(ParseGraph head) {
        return EMPTY.add(Util.checkNotNull(head, "head"));
    }

    public ParseGraphList add(ParseGraph head) {
        return new ParseGraphList(Util.checkNotNull(head, "head"), this);
    }

    public ParseGraphList add(ParseGraphList list) {
        Util.checkNotNull(list, "list");
        if (list.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return list;
        }
        return this.add(list.tail).add(list.head);
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }
}

