/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ParseGraphList;
import io.parsingdata.metal.data.ParseItem;
import io.parsingdata.metal.data.ParseItemList;
import io.parsingdata.metal.data.ParseRef;
import io.parsingdata.metal.data.ParseResult;
import io.parsingdata.metal.data.ParseValue;
import io.parsingdata.metal.data.ParseValueList;
import io.parsingdata.metal.data.selection.ByItem;
import io.parsingdata.metal.data.selection.ByName;
import io.parsingdata.metal.data.selection.ByOffset;
import io.parsingdata.metal.data.selection.ByToken;
import io.parsingdata.metal.data.selection.ByType;
import io.parsingdata.metal.data.transformation.Reversal;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.token.Token;
import java.io.IOException;

public class ParseGraph
implements ParseItem {
    public final ParseItem head;
    public final ParseGraph tail;
    public final boolean branched;
    public final Token definition;
    public final long size;
    public static final Token NONE = new Token(null){

        @Override
        protected ParseResult parseImpl(String scope, Environment env, Encoding enc) throws IOException {
            throw new IllegalStateException("This placeholder may not be invoked.");
        }

        public String toString() {
            return "None";
        }
    };
    public static final ParseGraph EMPTY = new ParseGraph(NONE);

    private ParseGraph(Token definition) {
        this.head = null;
        this.tail = null;
        this.branched = false;
        this.definition = Util.checkNotNull(definition, "definition");
        this.size = 0L;
    }

    private ParseGraph(ParseItem head, ParseGraph tail, Token definition, boolean branched) {
        this.head = Util.checkNotNull(head, "head");
        if (head.isValue() && branched) {
            throw new IllegalArgumentException("Argument branch cannot be true when head contains a ParseValue.");
        }
        this.tail = Util.checkNotNull(tail, "tail");
        this.branched = branched;
        this.definition = Util.checkNotNull(definition, "definition");
        this.size = tail.size + 1L;
    }

    public ParseGraph(ParseItem head, ParseGraph tail, Token definition) {
        this(head, tail, definition, false);
    }

    public ParseGraph add(ParseValue head) {
        if (this.branched) {
            return new ParseGraph(this.head.asGraph().add(head), this.tail, this.definition, true);
        }
        return new ParseGraph(head, this, this.definition);
    }

    public ParseGraph add(ParseRef ref) {
        if (this.branched) {
            return new ParseGraph(this.head.asGraph().add(ref), this.tail, this.definition, true);
        }
        return new ParseGraph(ref, this, this.definition);
    }

    public ParseGraph addBranch(Token definition) {
        if (this.branched) {
            return new ParseGraph(this.head.asGraph().addBranch(definition), this.tail, this.definition, true);
        }
        return new ParseGraph(new ParseGraph(definition), this, this.definition, true);
    }

    public ParseGraph closeBranch() {
        if (!this.branched) {
            throw new IllegalStateException("Cannot close branch that is not open.");
        }
        if (this.head.asGraph().branched) {
            return new ParseGraph(this.head.asGraph().closeBranch(), this.tail, this.definition, true);
        }
        return new ParseGraph(this.head, this.tail, this.definition, false);
    }

    public ParseGraphList getRefs() {
        return ByType.getRefs(this);
    }

    public ParseGraphList getGraphs() {
        return ByType.getGraphs(this);
    }

    public boolean containsValue() {
        if (this.isEmpty()) {
            return false;
        }
        return this.head.isValue() || this.tail.containsValue();
    }

    public ParseValue getLowestOffsetValue() {
        return ByOffset.getLowestOffsetValue(this);
    }

    public boolean hasGraphAtRef(long ref) {
        return ByOffset.hasGraphAtRef(this, ref);
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public ParseGraph reverse() {
        return Reversal.reverse(this, EMPTY);
    }

    public ParseValue get(String name) {
        return ByName.get(this, name);
    }

    public ParseItem get(Token definition) {
        return ByToken.get(this, definition);
    }

    public ParseValue current() {
        ParseValue val;
        if (this.isEmpty()) {
            return null;
        }
        if (this.head.isValue()) {
            return this.head.asValue();
        }
        if (this.head.isGraph() && (val = this.head.asGraph().current()) != null) {
            return val;
        }
        return this.tail.current();
    }

    public ParseValueList getAll(String name) {
        return ByName.getAll(this, name);
    }

    public ParseItemList getAll(Token definition) {
        return ByToken.getAll(this, definition);
    }

    public ParseGraph getGraphAfter(ParseItem lastHead) {
        return ByItem.getGraphAfter(this, lastHead);
    }

    @Override
    public boolean isValue() {
        return false;
    }

    @Override
    public boolean isGraph() {
        return true;
    }

    @Override
    public boolean isRef() {
        return false;
    }

    @Override
    public ParseValue asValue() {
        throw new UnsupportedOperationException("Cannot convert ParseGraph to ParseValue.");
    }

    @Override
    public ParseGraph asGraph() {
        return this;
    }

    @Override
    public ParseRef asRef() {
        throw new UnsupportedOperationException("Cannot convert ParseGraph to ParseRef.");
    }

    @Override
    public Token getDefinition() {
        return this.definition;
    }

    public String toString() {
        return "ParseGraph(" + (this.head != null ? this.head.toString() : "null") + ", " + (this.tail != null ? this.tail.toString() : "null") + ", " + this.branched + ")";
    }
}

