/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal;

import io.parsingdata.metal.token.Token;

public class Util {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static <T> T checkNotNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument " + name + " may not be null.");
        }
        return argument;
    }

    public static <T> T[] checkContainsNoNulls(T[] argument, String name) {
        Util.checkNotNull(argument, name);
        for (T arg : argument) {
            if (arg != null) continue;
            throw new IllegalArgumentException("Value in array " + name + " may not be null.");
        }
        return argument;
    }

    public static String tokensToString(Token[] tokens) {
        Util.checkNotNull(tokens, "tokens");
        if (tokens.length == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < tokens.length - 1; ++i) {
            out.append(tokens[i].toString());
            out.append(", ");
        }
        return out.append(tokens[tokens.length - 1]).toString();
    }

    public static String bytesToHexString(byte[] bytes) {
        Util.checkNotNull(bytes, "bytes");
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

