/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal;

import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.Expression;
import io.parsingdata.metal.expression.True;
import io.parsingdata.metal.expression.comparison.ComparisonExpression;
import io.parsingdata.metal.expression.comparison.Eq;
import io.parsingdata.metal.expression.comparison.EqNum;
import io.parsingdata.metal.expression.comparison.EqStr;
import io.parsingdata.metal.expression.comparison.GtNum;
import io.parsingdata.metal.expression.comparison.LtNum;
import io.parsingdata.metal.expression.logical.BinaryLogicalExpression;
import io.parsingdata.metal.expression.logical.Or;
import io.parsingdata.metal.expression.logical.UnaryLogicalExpression;
import io.parsingdata.metal.expression.value.BinaryValueExpression;
import io.parsingdata.metal.expression.value.Cat;
import io.parsingdata.metal.expression.value.Const;
import io.parsingdata.metal.expression.value.ConstantFactory;
import io.parsingdata.metal.expression.value.Elvis;
import io.parsingdata.metal.expression.value.FoldLeft;
import io.parsingdata.metal.expression.value.FoldRight;
import io.parsingdata.metal.expression.value.Reducer;
import io.parsingdata.metal.expression.value.UnaryValueExpression;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import io.parsingdata.metal.expression.value.arithmetic.Add;
import io.parsingdata.metal.expression.value.arithmetic.Div;
import io.parsingdata.metal.expression.value.arithmetic.Mod;
import io.parsingdata.metal.expression.value.arithmetic.Mul;
import io.parsingdata.metal.expression.value.arithmetic.Neg;
import io.parsingdata.metal.expression.value.bitwise.And;
import io.parsingdata.metal.expression.value.bitwise.Not;
import io.parsingdata.metal.expression.value.bitwise.ShiftLeft;
import io.parsingdata.metal.expression.value.bitwise.ShiftRight;
import io.parsingdata.metal.expression.value.reference.CurrentOffset;
import io.parsingdata.metal.expression.value.reference.First;
import io.parsingdata.metal.expression.value.reference.Len;
import io.parsingdata.metal.expression.value.reference.Offset;
import io.parsingdata.metal.expression.value.reference.Ref;
import io.parsingdata.metal.expression.value.reference.Self;
import io.parsingdata.metal.token.Cho;
import io.parsingdata.metal.token.Def;
import io.parsingdata.metal.token.Nod;
import io.parsingdata.metal.token.Opt;
import io.parsingdata.metal.token.Pre;
import io.parsingdata.metal.token.Rep;
import io.parsingdata.metal.token.RepN;
import io.parsingdata.metal.token.Seq;
import io.parsingdata.metal.token.Str;
import io.parsingdata.metal.token.StructSink;
import io.parsingdata.metal.token.Sub;
import io.parsingdata.metal.token.Token;
import io.parsingdata.metal.token.While;

public class Shorthand {
    public static final ValueExpression self = new Self();
    public static final ValueExpression currentOffset = new CurrentOffset();

    public static Token def(String name, ValueExpression size, Expression pred, Encoding encoding) {
        return new Def(name, size, pred, encoding);
    }

    public static Token def(String name, ValueExpression size, Expression pred) {
        return Shorthand.def(name, size, pred, null);
    }

    public static Token def(String name, ValueExpression size, Encoding enc) {
        return Shorthand.def(name, size, null, enc);
    }

    public static Token def(String name, ValueExpression size) {
        return Shorthand.def(name, size, null, null);
    }

    public static Token def(String name, long size, Expression pred, Encoding encoding) {
        return Shorthand.def(name, Shorthand.con(size), pred, encoding);
    }

    public static Token def(String name, long size, Expression pred) {
        return Shorthand.def(name, size, pred, null);
    }

    public static Token def(String name, long size, Encoding enc) {
        return Shorthand.def(name, size, null, enc);
    }

    public static Token def(String name, long size) {
        return Shorthand.def(name, size, null, null);
    }

    public static Token cho(Encoding e, Token ... tokens) {
        return new Cho(e, tokens);
    }

    public static Token cho(Token ... tokens) {
        return Shorthand.cho(null, tokens);
    }

    public static Token rep(Token t, Encoding e) {
        return new Rep(t, e);
    }

    public static Token rep(Token t) {
        return new Rep(t, null);
    }

    public static Token repn(Token t, ValueExpression n, Encoding e) {
        return new RepN(t, n, e);
    }

    public static Token repn(Token t, ValueExpression n) {
        return new RepN(t, n, null);
    }

    public static Token seq(Encoding e, Token ... tokens) {
        return new Seq(e, tokens);
    }

    public static Token seq(Token ... tokens) {
        return Shorthand.seq(null, tokens);
    }

    public static Token str(String n, Token t, Encoding e) {
        return Shorthand.str(n, t, e, null, null);
    }

    public static Token str(String n, Token t) {
        return Shorthand.str(n, t, null, null, null);
    }

    public static Token str(String n, Token t, Encoding e, StructSink s) {
        return new Str(n, t, e, s, null);
    }

    public static Token str(String n, Token t, StructSink s) {
        return Shorthand.str(n, t, null, s, null);
    }

    public static Token str(String n, Token t, Encoding e, StructSink s, Expression p) {
        return new Str(n, t, e, s, p);
    }

    public static Token str(String n, Token t, StructSink s, Expression p) {
        return Shorthand.str(n, t, null, s, p);
    }

    public static Token sub(Token t, ValueExpression a, Encoding e) {
        return new Sub(t, a, e);
    }

    public static Token sub(Token t, ValueExpression a) {
        return Shorthand.sub(t, a, null);
    }

    public static Token pre(Token t, Expression p, Encoding e) {
        return new Pre(t, p, e);
    }

    public static Token pre(Token t, Expression p) {
        return Shorthand.pre(t, p, null);
    }

    public static Token whl(Token t, Expression p, Encoding e) {
        return new While(t, p, e);
    }

    public static Token whl(Token t, Expression p) {
        return Shorthand.whl(t, p, null);
    }

    public static Token opt(Token t, Encoding e) {
        return new Opt(t, e);
    }

    public static Token opt(Token t) {
        return Shorthand.opt(t, null);
    }

    public static Token nod(ValueExpression s, Encoding e) {
        return new Nod(s, e);
    }

    public static Token nod(ValueExpression s) {
        return new Nod(s, null);
    }

    public static BinaryValueExpression add(ValueExpression l, ValueExpression r) {
        return new Add(l, r);
    }

    public static BinaryValueExpression div(ValueExpression l, ValueExpression r) {
        return new Div(l, r);
    }

    public static BinaryValueExpression mul(ValueExpression l, ValueExpression r) {
        return new Mul(l, r);
    }

    public static BinaryValueExpression sub(ValueExpression l, ValueExpression r) {
        return new io.parsingdata.metal.expression.value.arithmetic.Sub(l, r);
    }

    public static BinaryValueExpression mod(ValueExpression l, ValueExpression r) {
        return new Mod(l, r);
    }

    public static UnaryValueExpression neg(ValueExpression v) {
        return new Neg(v);
    }

    public static BinaryValueExpression and(ValueExpression l, ValueExpression r) {
        return new And(l, r);
    }

    public static BinaryValueExpression or(ValueExpression l, ValueExpression r) {
        return new io.parsingdata.metal.expression.value.bitwise.Or(l, r);
    }

    public static UnaryValueExpression not(ValueExpression v) {
        return new Not(v);
    }

    public static BinaryValueExpression shl(ValueExpression l, ValueExpression r) {
        return new ShiftLeft(l, r);
    }

    public static BinaryValueExpression shr(ValueExpression l, ValueExpression r) {
        return new ShiftRight(l, r);
    }

    public static ValueExpression con(long v) {
        return Shorthand.con(v, new Encoding());
    }

    public static ValueExpression con(long v, Encoding encoding) {
        return Shorthand.con(ConstantFactory.createFromNumeric(v, encoding));
    }

    public static ValueExpression con(String s) {
        return Shorthand.con(s, new Encoding());
    }

    public static ValueExpression con(String s, Encoding encoding) {
        return Shorthand.con(ConstantFactory.createFromString(s, encoding));
    }

    public static ValueExpression con(Value v) {
        return new Const(v);
    }

    public static ValueExpression con(Encoding enc, int ... values) {
        return new Const(new Value(Shorthand.toByteArray(values), enc));
    }

    public static ValueExpression con(int ... values) {
        return Shorthand.con(new Encoding(), values);
    }

    public static ValueExpression len(ValueExpression v) {
        return new Len(v);
    }

    public static ValueExpression ref(String s) {
        return new Ref(s);
    }

    public static ValueExpression first(String s) {
        return new First(s);
    }

    public static ValueExpression offset(String s) {
        return new Offset(s);
    }

    public static ValueExpression cat(ValueExpression l, ValueExpression r) {
        return new Cat(l, r);
    }

    public static ValueExpression elvis(ValueExpression l, ValueExpression r) {
        return new Elvis(l, r);
    }

    public static ValueExpression foldLeft(String name, Reducer reducer) {
        return new FoldLeft(name, reducer, null);
    }

    public static ValueExpression foldLeft(String name, Reducer reducer, ValueExpression i) {
        return new FoldLeft(name, reducer, i);
    }

    public static ValueExpression foldRight(String name, Reducer reducer) {
        return new FoldRight(name, reducer, null);
    }

    public static ValueExpression foldRight(String name, Reducer reducer, ValueExpression i) {
        return new FoldRight(name, reducer, i);
    }

    public static ValueExpression fold(String name, Reducer reducer) {
        return Shorthand.foldRight(name, reducer);
    }

    public static ValueExpression fold(String name, Reducer reducer, ValueExpression i) {
        return Shorthand.foldRight(name, reducer, i);
    }

    public static BinaryLogicalExpression and(Expression l, Expression r) {
        return new io.parsingdata.metal.expression.logical.And(l, r);
    }

    public static BinaryLogicalExpression or(Expression l, Expression r) {
        return new Or(l, r);
    }

    public static UnaryLogicalExpression not(Expression e) {
        return new io.parsingdata.metal.expression.logical.Not(e);
    }

    public static Expression expTrue() {
        return new True();
    }

    public static ComparisonExpression eq(ValueExpression p) {
        return new Eq(null, p);
    }

    public static ComparisonExpression eq(ValueExpression c, ValueExpression p) {
        return new Eq(c, p);
    }

    public static ComparisonExpression eqStr(ValueExpression p) {
        return new EqStr(null, p);
    }

    public static ComparisonExpression eqStr(ValueExpression c, ValueExpression p) {
        return new EqStr(c, p);
    }

    public static ComparisonExpression eqNum(ValueExpression p) {
        return new EqNum(null, p);
    }

    public static ComparisonExpression eqNum(ValueExpression c, ValueExpression p) {
        return new EqNum(c, p);
    }

    public static ComparisonExpression gtNum(ValueExpression p) {
        return new GtNum(null, p);
    }

    public static ComparisonExpression gtNum(ValueExpression c, ValueExpression p) {
        return new GtNum(c, p);
    }

    public static ComparisonExpression ltNum(ValueExpression p) {
        return new LtNum(null, p);
    }

    public static ComparisonExpression ltNum(ValueExpression c, ValueExpression p) {
        return new LtNum(c, p);
    }

    public static byte[] toByteArray(int ... bytes) {
        byte[] out = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            out[i] = (byte)bytes[i];
        }
        return out;
    }
}

