/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.interceptor;

import io.opentracing.Span;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;

public interface SpanDecorator {
    public static final SpanDecorator STANDARD_TAGS = new SpanDecorator(){

        @Override
        public void onPreHandle(HttpServletRequest httpServletRequest, Object handler, Span span) {
            HashMap<String, Object> logs = new HashMap<String, Object>(3);
            logs.put("event", "preHandle");
            logs.put("handler", handler);
            String metaData = HandlerUtils.className(handler);
            if (metaData != null) {
                logs.put("handler.class_simple_name", metaData);
            }
            if ((metaData = HandlerUtils.methodName(handler)) != null) {
                logs.put("handler.method_name", metaData);
            }
            span.log(logs);
        }

        @Override
        public void onAfterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler, Exception ex, Span span) {
            HashMap<String, Object> logs = new HashMap<String, Object>(2);
            logs.put("event", "afterCompletion");
            logs.put("handler", handler);
            span.log(logs);
        }
    };

    public void onPreHandle(HttpServletRequest var1, Object var2, Span var3);

    public void onAfterCompletion(HttpServletRequest var1, HttpServletResponse var2, Object var3, Exception var4, Span var5);

    public static class HandlerUtils {
        public static final String HANDLER_CLASS_NAME = "handler.class_simple_name";
        public static final String HANDLER_METHOD_NAME = "handler.method_name";
        public static final String HANDLER = "handler";

        private HandlerUtils() {
        }

        public static String className(Object handler) {
            return handler instanceof HandlerMethod ? ((HandlerMethod)handler).getBeanType().getSimpleName() : handler.getClass().getSimpleName();
        }

        public static String methodName(Object handler) {
            return handler instanceof HandlerMethod ? ((HandlerMethod)handler).getMethod().getName() : null;
        }

        public static String requestMapping(Object handler) {
            Object[] mappings = ((RequestMapping)((HandlerMethod)handler).getMethodAnnotation(RequestMapping.class)).path();
            return Arrays.toString(mappings);
        }
    }
}

