/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.zpages;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.extension.zpages.LatencyBoundary;
import io.opentelemetry.sdk.extension.zpages.SpanBucket;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

final class TracezSpanBuckets {
    private final LatencyBuckets latencyBuckets = new LatencyBuckets();
    private final SpanBucket errors = new SpanBucket(false);

    TracezSpanBuckets() {
    }

    void addToBucket(ReadableSpan span) {
        StatusData status = span.toSpanData().getStatus();
        if (status.getStatusCode() != StatusCode.ERROR) {
            this.latencyBuckets.get(LatencyBoundary.getBoundary(span.getLatencyNanos())).add(span);
            return;
        }
        this.errors.add(span);
    }

    Map<LatencyBoundary, Integer> getLatencyBoundaryToCountMap() {
        EnumMap<LatencyBoundary, Integer> latencyCounts = new EnumMap<LatencyBoundary, Integer>(LatencyBoundary.class);
        for (LatencyBoundary bucket : LatencyBoundary.values()) {
            latencyCounts.put(bucket, this.latencyBuckets.get(bucket).size());
        }
        return latencyCounts;
    }

    List<ReadableSpan> getOkSpans() {
        ArrayList<ReadableSpan> okSpans = new ArrayList<ReadableSpan>();
        this.latencyBuckets.addTo(okSpans);
        return okSpans;
    }

    List<ReadableSpan> getErrorSpans() {
        ArrayList<ReadableSpan> errorSpans = new ArrayList<ReadableSpan>();
        this.errors.addTo(errorSpans);
        return errorSpans;
    }

    List<ReadableSpan> getSpans() {
        ArrayList<ReadableSpan> spans = new ArrayList<ReadableSpan>();
        spans.addAll(this.getOkSpans());
        spans.addAll(this.getErrorSpans());
        return spans;
    }

    private static class LatencyBuckets {
        final SpanBucket zeroToTenMicros = new SpanBucket(true);
        final SpanBucket tenMicrosToHundredMicros = new SpanBucket(true);
        final SpanBucket hundredMicrosToOneMilli = new SpanBucket(true);
        final SpanBucket oneMilliToTenMillis = new SpanBucket(true);
        final SpanBucket tenMillisToHundredMillis = new SpanBucket(true);
        final SpanBucket hundredMillisToOneSecond = new SpanBucket(true);
        final SpanBucket oneSecondToTenSeconds = new SpanBucket(true);
        final SpanBucket tenSecondsToHundredSeconds = new SpanBucket(true);
        final SpanBucket hundredSecondsToMax = new SpanBucket(true);

        private LatencyBuckets() {
        }

        void addTo(List<ReadableSpan> spans) {
            this.zeroToTenMicros.addTo(spans);
            this.tenMicrosToHundredMicros.addTo(spans);
            this.hundredMicrosToOneMilli.addTo(spans);
            this.oneMilliToTenMillis.addTo(spans);
            this.tenMillisToHundredMillis.addTo(spans);
            this.hundredMillisToOneSecond.addTo(spans);
            this.oneSecondToTenSeconds.addTo(spans);
            this.tenSecondsToHundredSeconds.addTo(spans);
            this.hundredSecondsToMax.addTo(spans);
        }

        SpanBucket get(LatencyBoundary boundary) {
            switch (boundary) {
                case ZERO_MICROSx10: {
                    return this.zeroToTenMicros;
                }
                case MICROSx10_MICROSx100: {
                    return this.tenMicrosToHundredMicros;
                }
                case MICROSx100_MILLIx1: {
                    return this.hundredMicrosToOneMilli;
                }
                case MILLIx1_MILLIx10: {
                    return this.oneMilliToTenMillis;
                }
                case MILLIx10_MILLIx100: {
                    return this.tenMillisToHundredMillis;
                }
                case MILLIx100_SECONDx1: {
                    return this.hundredMillisToOneSecond;
                }
                case SECONDx1_SECONDx10: {
                    return this.oneSecondToTenSeconds;
                }
                case SECONDx10_SECONDx100: {
                    return this.tenSecondsToHundredSeconds;
                }
                case SECONDx100_MAX: {
                    return this.hundredSecondsToMax;
                }
            }
            return this.hundredSecondsToMax;
        }
    }
}

