/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.zpages;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.opentelemetry.sdk.extension.zpages.ZPageHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class ZPageHttpHandler
implements HttpHandler {
    private static final String PARAM_SPAN_NAME = "zspanname";
    private final ZPageHandler zpageHandler;

    ZPageHttpHandler(ZPageHandler zpageHandler) {
        this.zpageHandler = zpageHandler;
    }

    static Map<String, String> parseQueryString(String queryString) {
        if (queryString == null) {
            return Collections.emptyMap();
        }
        HashMap queryMap = new HashMap();
        Arrays.stream(queryString.split("&")).map(String::trim).filter(s -> !s.isEmpty()).forEach(param -> {
            List keyValuePair = Arrays.stream(param.split("=")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            if (keyValuePair.size() > 1) {
                if (((String)keyValuePair.get(0)).equals(PARAM_SPAN_NAME)) {
                    try {
                        queryMap.put((String)keyValuePair.get(0), URLDecoder.decode((String)keyValuePair.get(1), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                } else {
                    queryMap.put((String)keyValuePair.get(0), (String)keyValuePair.get(1));
                }
            }
        });
        return Collections.unmodifiableMap(queryMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(HttpExchange httpExchange) throws IOException {
        block10: {
            try {
                String queryString;
                String requestMethod = httpExchange.getRequestMethod();
                httpExchange.sendResponseHeaders(200, 0L);
                if (requestMethod.equalsIgnoreCase("GET")) {
                    this.zpageHandler.emitHtml(ZPageHttpHandler.parseQueryString(httpExchange.getRequestURI().getRawQuery()), httpExchange.getResponseBody());
                    break block10;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(httpExchange.getRequestBody(), "utf-8"));){
                    queryString = reader.readLine();
                }
                boolean error = this.zpageHandler.processRequest(requestMethod, ZPageHttpHandler.parseQueryString(queryString), httpExchange.getResponseBody());
                if (!error) {
                    this.zpageHandler.emitHtml(ZPageHttpHandler.parseQueryString(queryString), httpExchange.getResponseBody());
                }
            }
            finally {
                httpExchange.close();
            }
        }
    }
}

