/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.zpages;

import io.opentelemetry.sdk.extension.zpages.TracezTraceConfigSupplier;
import io.opentelemetry.sdk.extension.zpages.ZPageHandler;
import io.opentelemetry.sdk.extension.zpages.ZPageLogo;
import io.opentelemetry.sdk.extension.zpages.ZPageStyle;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.sdk.trace.config.TraceConfigBuilder;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TraceConfigzZPageHandler
extends ZPageHandler {
    private static final String TRACE_CONFIGZ_URL = "/traceconfigz";
    private static final String TRACE_CONFIGZ_NAME = "TraceConfigZ";
    private static final String TRACE_CONFIGZ_DESCRIPTION = "TraceConfigZ displays information about the current active tracing configuration and allows users to change it";
    private static final String QUERY_STRING_ACTION = "action";
    private static final String QUERY_STRING_ACTION_CHANGE = "change";
    private static final String QUERY_STRING_ACTION_DEFAULT = "default";
    private static final String QUERY_STRING_SAMPLING_PROBABILITY = "samplingprobability";
    private static final String QUERY_STRING_MAX_NUM_OF_ATTRIBUTES = "maxnumofattributes";
    private static final String QUERY_STRING_MAX_NUM_OF_EVENTS = "maxnumofevents";
    private static final String QUERY_STRING_MAX_NUM_OF_LINKS = "maxnumoflinks";
    private static final String QUERY_STRING_MAX_NUM_OF_ATTRIBUTES_PER_EVENT = "maxnumofattributesperevent";
    private static final String QUERY_STRING_MAX_NUM_OF_ATTRIBUTES_PER_LINK = "maxnumofattributesperlink";
    private static final String ZEBRA_STRIPE_COLOR = "#e6e6e6";
    private static final Logger logger = Logger.getLogger(TraceConfigzZPageHandler.class.getName());
    private final TracezTraceConfigSupplier configSupplier;

    TraceConfigzZPageHandler(TracezTraceConfigSupplier configSupplier) {
        this.configSupplier = configSupplier;
    }

    @Override
    public String getUrlPath() {
        return TRACE_CONFIGZ_URL;
    }

    @Override
    public String getPageName() {
        return TRACE_CONFIGZ_NAME;
    }

    @Override
    public String getPageDescription() {
        return TRACE_CONFIGZ_DESCRIPTION;
    }

    private static void emitHtmlStyle(PrintStream out) {
        out.print("<style>");
        out.print(ZPageStyle.style);
        out.print("</style>");
    }

    private static void emitChangeTableRow(PrintStream out, String rowName, String paramName, String inputPlaceHolder, String paramDefaultValue, String zebraStripeColor, boolean zebraStripe) {
        if (zebraStripe) {
            out.print("<tr style=\"background-color: " + zebraStripeColor + ";\">");
        } else {
            out.print("<tr>");
        }
        out.print("<td>Update " + rowName + "</td>");
        out.print("<td class=\"border-left-dark\"><input type=text size=15 name=" + paramName + " value=\"\" placeholder=\"" + inputPlaceHolder + "\" /></td>");
        out.print("<td class=\"border-left-dark\">(" + paramDefaultValue + ")</td>");
        out.print("</tr>");
    }

    private static void emitChangeTable(PrintStream out) {
        out.print("<table style=\"border-spacing: 0; border: 1px solid #363636;\">");
        out.print("<tr class=\"bg-color\">");
        out.print("<th colspan=2 style=\"text-align: left;\" class=\"header-text\"><b>Update active TraceConfig</b></th>");
        out.print("<th colspan=1 class=\"header-text border-left-white\"><b>Default</b></th>");
        TraceConfigzZPageHandler.emitChangeTableRow(out, "SamplingProbability to", QUERY_STRING_SAMPLING_PROBABILITY, "[0.0, 1.0]", "1.0", ZEBRA_STRIPE_COLOR, false);
        TraceConfigzZPageHandler.emitChangeTableRow(out, "MaxNumberOfAttributes to", QUERY_STRING_MAX_NUM_OF_ATTRIBUTES, "", Integer.toString(TraceConfig.getDefault().getMaxNumberOfAttributes()), ZEBRA_STRIPE_COLOR, true);
        TraceConfigzZPageHandler.emitChangeTableRow(out, "MaxNumberOfEvents to", QUERY_STRING_MAX_NUM_OF_EVENTS, "", Integer.toString(TraceConfig.getDefault().getMaxNumberOfEvents()), ZEBRA_STRIPE_COLOR, false);
        TraceConfigzZPageHandler.emitChangeTableRow(out, "MaxNumberOfLinks to", QUERY_STRING_MAX_NUM_OF_LINKS, "", Integer.toString(TraceConfig.getDefault().getMaxNumberOfLinks()), ZEBRA_STRIPE_COLOR, true);
        TraceConfigzZPageHandler.emitChangeTableRow(out, "MaxNumberOfAttributesPerEvent to", QUERY_STRING_MAX_NUM_OF_ATTRIBUTES_PER_EVENT, "", Integer.toString(TraceConfig.getDefault().getMaxNumberOfAttributesPerEvent()), ZEBRA_STRIPE_COLOR, false);
        TraceConfigzZPageHandler.emitChangeTableRow(out, "MaxNumberOfAttributesPerLink to", QUERY_STRING_MAX_NUM_OF_ATTRIBUTES_PER_LINK, "", Integer.toString(TraceConfig.getDefault().getMaxNumberOfAttributesPerLink()), ZEBRA_STRIPE_COLOR, true);
        out.print("</table>");
    }

    private static void emitActiveTableRow(PrintStream out, String paramName, String paramValue, String zebraStripeColor, boolean zebraStripe) {
        if (zebraStripe) {
            out.print("<tr style=\"background-color: " + zebraStripeColor + ";\">");
        } else {
            out.print("<tr>");
        }
        out.print("<td>" + paramName + "</td>");
        out.print("<td class=\"border-left-dark\">" + paramValue + "</td>");
        out.print("</tr>");
    }

    private void emitActiveTable(PrintStream out) {
        out.print("<table style=\"border-spacing: 0; border: 1px solid #363636;\">");
        out.print("<tr class=\"bg-color\">");
        out.print("<th class=\"header-text\"><b>Name</b></th>");
        out.print("<th class=\"header-text border-left-white\"><b>Value</b></th>");
        out.print("</tr>");
        TraceConfigzZPageHandler.emitActiveTableRow(out, "Sampler", this.configSupplier.getSampler().getDescription(), ZEBRA_STRIPE_COLOR, false);
        TraceConfigzZPageHandler.emitActiveTableRow(out, "MaxNumOfAttributes", Integer.toString(this.configSupplier.get().getMaxNumberOfAttributes()), ZEBRA_STRIPE_COLOR, true);
        TraceConfigzZPageHandler.emitActiveTableRow(out, "MaxNumOfEvents", Integer.toString(this.configSupplier.get().getMaxNumberOfEvents()), ZEBRA_STRIPE_COLOR, false);
        TraceConfigzZPageHandler.emitActiveTableRow(out, "MaxNumOfLinks", Integer.toString(this.configSupplier.get().getMaxNumberOfLinks()), ZEBRA_STRIPE_COLOR, true);
        TraceConfigzZPageHandler.emitActiveTableRow(out, "MaxNumOfAttributesPerEvent", Integer.toString(this.configSupplier.get().getMaxNumberOfAttributesPerEvent()), ZEBRA_STRIPE_COLOR, false);
        TraceConfigzZPageHandler.emitActiveTableRow(out, "MaxNumOfAttributesPerLink", Integer.toString(this.configSupplier.get().getMaxNumberOfAttributesPerLink()), ZEBRA_STRIPE_COLOR, true);
        out.print("</table>");
    }

    private void emitHtmlBody(PrintStream out) {
        out.print("<a href=\"/\"><img style=\"height: 90px;\" src=\"data:image/png;base64," + ZPageLogo.getLogoBase64() + "\" /></a>");
        out.print("<h1>Trace Configuration</h1>");
        out.print("<form class=\"form-flex\" action=\"/traceconfigz\" method=\"post\">");
        out.print("<input type=\"hidden\" name=\"action\" value=\"change\" />");
        TraceConfigzZPageHandler.emitChangeTable(out);
        out.print("<button class=\"button\" type=\"submit\" value=\"Submit\">Submit</button>");
        out.print("</form>");
        out.print("<form class=\"form-flex\" action=\"/traceconfigz\" method=\"post\">");
        out.print("<input type=\"hidden\" name=\"action\" value=\"default\" />");
        out.print("<button class=\"button\" type=\"submit\" value=\"Submit\">Restore Default</button>");
        out.print("</form>");
        out.print("<h2>Active Tracing Parameters</h2>");
        this.emitActiveTable(out);
    }

    @Override
    public void emitHtml(Map<String, String> queryMap, OutputStream outputStream) {
        try (PrintStream out = new PrintStream(outputStream, false, "UTF-8");){
            out.print("<!DOCTYPE html>");
            out.print("<html lang=\"en\">");
            out.print("<head>");
            out.print("<meta charset=\"UTF-8\">");
            out.print("<link rel=\"shortcut icon\" href=\"data:image/png;base64," + ZPageLogo.getFaviconBase64() + "\" type=\"image/png\">");
            out.print("<link href=\"https://fonts.googleapis.com/css?family=Open+Sans:300\"rel=\"stylesheet\">");
            out.print("<link href=\"https://fonts.googleapis.com/css?family=Roboto\" rel=\"stylesheet\">");
            out.print("<title>TraceConfigZ</title>");
            TraceConfigzZPageHandler.emitHtmlStyle(out);
            out.print("</head>");
            out.print("<body>");
            try {
                this.emitHtmlBody(out);
            }
            catch (Throwable t) {
                out.print("Error while generating HTML: " + t.toString());
                logger.log(Level.WARNING, "error while generating HTML", t);
            }
            out.print("</body>");
            out.print("</html>");
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "error while generating HTML", t);
        }
    }

    @Override
    public boolean processRequest(String requestMethod, Map<String, String> queryMap, OutputStream outputStream) {
        if (requestMethod.equalsIgnoreCase("POST")) {
            try {
                this.applyTraceConfig(queryMap);
            }
            catch (Throwable t) {
                try (PrintStream out = new PrintStream(outputStream, false, "UTF-8");){
                    out.print("<!DOCTYPE html>");
                    out.print("<html lang=\"en\">");
                    out.print("<head>");
                    out.print("<meta charset=\"UTF-8\">");
                    out.print("<link rel=\"shortcut icon\" href=\"data:image/png;base64," + ZPageLogo.getFaviconBase64() + "\" type=\"image/png\">");
                    out.print("<link href=\"https://fonts.googleapis.com/css?family=Open+Sans:300\"rel=\"stylesheet\">");
                    out.print("<link href=\"https://fonts.googleapis.com/css?family=Roboto\" rel=\"stylesheet\">");
                    out.print("<title>TraceConfigZ</title>");
                    out.print("</head>");
                    out.print("<body>");
                    out.print("Error while applying trace config changes: " + t.toString());
                    out.print("</body>");
                    out.print("</html>");
                    logger.log(Level.WARNING, "error while applying trace config changes", t);
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "error while applying trace config changes", e);
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private void applyTraceConfig(Map<String, String> queryMap) {
        String action = queryMap.get(QUERY_STRING_ACTION);
        if (action == null) {
            return;
        }
        if (action.equals(QUERY_STRING_ACTION_CHANGE)) {
            String maxNumOfAttributesPerLinkStr;
            String maxNumOfAttributesPerEventStr;
            String maxNumOfLinksStr;
            String maxNumOfEventsStr;
            String maxNumOfAttributesStr;
            TraceConfigBuilder newConfigBuilder = this.configSupplier.get().toBuilder();
            String samplingProbabilityStr = queryMap.get(QUERY_STRING_SAMPLING_PROBABILITY);
            if (samplingProbabilityStr != null) {
                try {
                    double samplingProbability = Double.parseDouble(samplingProbabilityStr);
                    this.configSupplier.setSampler(Sampler.traceIdRatioBased((double)samplingProbability));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("SamplingProbability must be of the type double", e);
                }
            }
            if ((maxNumOfAttributesStr = queryMap.get(QUERY_STRING_MAX_NUM_OF_ATTRIBUTES)) != null) {
                try {
                    int maxNumOfAttributes = Integer.parseInt(maxNumOfAttributesStr);
                    newConfigBuilder.setMaxNumberOfAttributes(maxNumOfAttributes);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("MaxNumOfAttributes must be of the type integer", e);
                }
            }
            if ((maxNumOfEventsStr = queryMap.get(QUERY_STRING_MAX_NUM_OF_EVENTS)) != null) {
                try {
                    int maxNumOfEvents = Integer.parseInt(maxNumOfEventsStr);
                    newConfigBuilder.setMaxNumberOfEvents(maxNumOfEvents);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("MaxNumOfEvents must be of the type integer", e);
                }
            }
            if ((maxNumOfLinksStr = queryMap.get(QUERY_STRING_MAX_NUM_OF_LINKS)) != null) {
                try {
                    int maxNumOfLinks = Integer.parseInt(maxNumOfLinksStr);
                    newConfigBuilder.setMaxNumberOfLinks(maxNumOfLinks);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("MaxNumOfLinks must be of the type integer", e);
                }
            }
            if ((maxNumOfAttributesPerEventStr = queryMap.get(QUERY_STRING_MAX_NUM_OF_ATTRIBUTES_PER_EVENT)) != null) {
                try {
                    int maxNumOfAttributesPerEvent = Integer.parseInt(maxNumOfAttributesPerEventStr);
                    newConfigBuilder.setMaxNumberOfAttributesPerEvent(maxNumOfAttributesPerEvent);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("MaxNumOfAttributesPerEvent must be of the type integer", e);
                }
            }
            if ((maxNumOfAttributesPerLinkStr = queryMap.get(QUERY_STRING_MAX_NUM_OF_ATTRIBUTES_PER_LINK)) != null) {
                try {
                    int maxNumOfAttributesPerLink = Integer.parseInt(maxNumOfAttributesPerLinkStr);
                    newConfigBuilder.setMaxNumberOfAttributesPerLink(maxNumOfAttributesPerLink);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("MaxNumOfAttributesPerLink must be of the type integer", e);
                }
            }
            this.configSupplier.setActiveTraceConfig(newConfigBuilder.build());
        } else if (action.equals(QUERY_STRING_ACTION_DEFAULT)) {
            TraceConfig defaultConfig = TraceConfig.builder().build();
            this.configSupplier.setActiveTraceConfig(defaultConfig);
        }
    }
}

