/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.zpages;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.extension.zpages.TracezSpanBuckets;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TracezSpanProcessor
implements SpanProcessor {
    private final ConcurrentMap<String, ReadableSpan> runningSpanCache = new ConcurrentHashMap<String, ReadableSpan>();
    private final ConcurrentMap<String, TracezSpanBuckets> completedSpanCache = new ConcurrentHashMap<String, TracezSpanBuckets>();
    private final boolean sampled;

    TracezSpanProcessor(boolean sampled) {
        this.sampled = sampled;
    }

    public void onStart(Context parentContext, ReadWriteSpan span) {
        this.runningSpanCache.put(span.getSpanContext().getSpanIdAsHexString(), (ReadableSpan)span);
    }

    public boolean isStartRequired() {
        return true;
    }

    public void onEnd(ReadableSpan span) {
        this.runningSpanCache.remove(span.getSpanContext().getSpanIdAsHexString());
        if (!this.sampled || span.getSpanContext().isSampled()) {
            this.completedSpanCache.putIfAbsent(span.getName(), new TracezSpanBuckets());
            ((TracezSpanBuckets)this.completedSpanCache.get(span.getName())).addToBucket(span);
        }
    }

    public boolean isEndRequired() {
        return true;
    }

    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    Collection<ReadableSpan> getRunningSpans() {
        return this.runningSpanCache.values();
    }

    Collection<ReadableSpan> getCompletedSpans() {
        ArrayList<ReadableSpan> completedSpans = new ArrayList<ReadableSpan>();
        for (TracezSpanBuckets buckets : this.completedSpanCache.values()) {
            completedSpans.addAll(buckets.getSpans());
        }
        return completedSpans;
    }

    Map<String, TracezSpanBuckets> getCompletedSpanCache() {
        return this.completedSpanCache;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ConfigBuilder<Builder> {
        private static final String KEY_SAMPLED = "otel.zpages.export.sampled";
        private static final boolean DEFAULT_EXPORT_ONLY_SAMPLED = true;
        private boolean sampled = true;

        private Builder() {
        }

        protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
            Boolean boolValue = Builder.getBooleanProperty((String)KEY_SAMPLED, (Map)(configMap = namingConvention.normalize(configMap)));
            if (boolValue != null) {
                return this.setExportOnlySampled(boolValue);
            }
            return this;
        }

        public Builder setExportOnlySampled(boolean sampled) {
            this.sampled = sampled;
            return this;
        }

        public TracezSpanProcessor build() {
            return new TracezSpanProcessor(this.sampled);
        }
    }
}

