/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.zpages;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.extension.zpages.LatencyBoundary;
import io.opentelemetry.sdk.extension.zpages.SpanBucket;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class TracezSpanBuckets {
    private final Map<LatencyBoundary, SpanBucket> latencyBuckets = new HashMap<LatencyBoundary, SpanBucket>();
    private final Map<StatusCode, SpanBucket> errorBuckets = new HashMap<StatusCode, SpanBucket>();

    TracezSpanBuckets() {
        for (LatencyBoundary latencyBoundary : LatencyBoundary.values()) {
            this.latencyBuckets.put(latencyBoundary, new SpanBucket(true));
        }
        for (LatencyBoundary latencyBoundary : StatusCode.values()) {
            if (latencyBoundary != StatusCode.ERROR) continue;
            this.errorBuckets.put((StatusCode)latencyBoundary, new SpanBucket(false));
        }
    }

    void addToBucket(ReadableSpan span) {
        StatusData status = span.toSpanData().getStatus();
        if (status.getStatusCode() != StatusCode.ERROR) {
            this.latencyBuckets.get((Object)LatencyBoundary.getBoundary(span.getLatencyNanos())).add(span);
            return;
        }
        this.errorBuckets.get(status.getStatusCode()).add(span);
    }

    Map<LatencyBoundary, Integer> getLatencyBoundaryToCountMap() {
        EnumMap<LatencyBoundary, Integer> latencyCounts = new EnumMap<LatencyBoundary, Integer>(LatencyBoundary.class);
        for (LatencyBoundary bucket : LatencyBoundary.values()) {
            latencyCounts.put(bucket, this.latencyBuckets.get((Object)bucket).size());
        }
        return latencyCounts;
    }

    List<ReadableSpan> getOkSpans() {
        ArrayList<ReadableSpan> okSpans = new ArrayList<ReadableSpan>();
        for (SpanBucket latencyBucket : this.latencyBuckets.values()) {
            latencyBucket.addTo(okSpans);
        }
        return okSpans;
    }

    List<ReadableSpan> getErrorSpans() {
        ArrayList<ReadableSpan> errorSpans = new ArrayList<ReadableSpan>();
        for (SpanBucket errorBucket : this.errorBuckets.values()) {
            errorBucket.addTo(errorSpans);
        }
        return errorSpans;
    }

    List<ReadableSpan> getSpans() {
        ArrayList<ReadableSpan> spans = new ArrayList<ReadableSpan>();
        spans.addAll(this.getOkSpans());
        spans.addAll(this.getErrorSpans());
        return spans;
    }
}

