/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.metrics;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.exporter.otlp.internal.TlsUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.OkHttpClient;

public final class OtlpHttpMetricExporterBuilder {
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/metrics";
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private String endpoint = "http://localhost:4318/v1/metrics";
    private boolean compressionEnabled = false;
    @Nullable
    private Headers.Builder headersBuilder;
    @Nullable
    private byte[] trustedCertificatesPem;

    public OtlpHttpMetricExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpMetricExporterBuilder setEndpoint(String endpoint) {
        URI uri;
        Objects.requireNonNull(endpoint, "endpoint");
        try {
            uri = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint, must be a URL: " + endpoint, e);
        }
        if (uri.getScheme() == null || !uri.getScheme().equals("http") && !uri.getScheme().equals("https")) {
            throw new IllegalArgumentException("Invalid endpoint, must start with http:// or https://: " + uri);
        }
        this.endpoint = endpoint;
        return this;
    }

    public OtlpHttpMetricExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument((compressionMethod.equals("gzip") || compressionMethod.equals("none") ? 1 : 0) != 0, (String)"Unsupported compression method. Supported compression methods include: gzip, none.");
        if (compressionMethod.equals("gzip")) {
            this.compressionEnabled = true;
        }
        return this;
    }

    public OtlpHttpMetricExporterBuilder addHeader(String key, String value) {
        if (this.headersBuilder == null) {
            this.headersBuilder = new Headers.Builder();
        }
        this.headersBuilder.add(key, value);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.trustedCertificatesPem = trustedCertificatesPem;
        return this;
    }

    public OtlpHttpMetricExporter build() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().callTimeout(Duration.ofNanos(this.timeoutNanos));
        if (this.trustedCertificatesPem != null) {
            try {
                X509TrustManager trustManager = TlsUtil.trustManager((byte[])this.trustedCertificatesPem);
                clientBuilder.sslSocketFactory(TlsUtil.sslSocketFactory((TrustManager)trustManager), trustManager);
            }
            catch (SSLException e) {
                throw new IllegalStateException("Could not set trusted certificate for OTLP HTTP connection, are they valid X.509 in PEM format?", e);
            }
        }
        Headers headers = this.headersBuilder == null ? null : this.headersBuilder.build();
        return new OtlpHttpMetricExporter(clientBuilder.build(), this.endpoint, headers, this.compressionEnabled);
    }

    OtlpHttpMetricExporterBuilder() {
    }
}

