/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.metrics;

import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.ProtoRequestBody;
import io.opentelemetry.exporter.otlp.internal.grpc.GrpcStatusUtil;
import io.opentelemetry.exporter.otlp.internal.metrics.MetricsRequestMarshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

@ThreadSafe
public final class OtlpHttpMetricExporter
implements MetricExporter {
    private static final Logger internalLogger = Logger.getLogger(OtlpHttpMetricExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final OkHttpClient client;
    private final String endpoint;
    @Nullable
    private final Headers headers;
    private final boolean compressionEnabled;

    OtlpHttpMetricExporter(OkHttpClient client, String endpoint, @Nullable Headers headers, boolean compressionEnabled) {
        this.client = client;
        this.endpoint = endpoint;
        this.headers = headers;
        this.compressionEnabled = compressionEnabled;
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        MetricsRequestMarshaler exportRequest = MetricsRequestMarshaler.create(metrics);
        Request.Builder requestBuilder = new Request.Builder().url(this.endpoint);
        if (this.headers != null) {
            requestBuilder.headers(this.headers);
        }
        ProtoRequestBody requestBody = new ProtoRequestBody((Marshaler)exportRequest);
        if (this.compressionEnabled) {
            requestBuilder.addHeader("Content-Encoding", "gzip");
            requestBuilder.post(OtlpHttpMetricExporter.gzipRequestBody((RequestBody)requestBody));
        } else {
            requestBuilder.post((RequestBody)requestBody);
        }
        final CompletableResultCode result = new CompletableResultCode();
        this.client.newCall(requestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OtlpHttpMetricExporter.this.logger.log(Level.SEVERE, "Failed to export metrics. The request could not be executed. Full error message: " + e.getMessage());
                result.fail();
            }

            public void onResponse(Call call, Response response) {
                if (response.isSuccessful()) {
                    result.succeed();
                    return;
                }
                int code = response.code();
                String status = OtlpHttpMetricExporter.extractErrorStatus(response);
                OtlpHttpMetricExporter.this.logger.log(Level.WARNING, "Failed to export metrics. Server responded with HTTP status code " + code + ". Error message: " + status);
                result.fail();
            }
        });
        return result;
    }

    private static RequestBody gzipRequestBody(final RequestBody requestBody) {
        return new RequestBody(){

            public MediaType contentType() {
                return requestBody.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(BufferedSink bufferedSink) throws IOException {
                BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)bufferedSink));
                requestBody.writeTo(gzipSink);
                gzipSink.close();
            }
        };
    }

    private static String extractErrorStatus(Response response) {
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            return "Response body missing, HTTP status message: " + response.message();
        }
        try {
            return GrpcStatusUtil.getStatusMessage((byte[])responseBody.bytes());
        }
        catch (IOException e) {
            return "Unable to parse response body, HTTP status message: " + response.message();
        }
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public static OtlpHttpMetricExporterBuilder builder() {
        return new OtlpHttpMetricExporterBuilder();
    }

    public static OtlpHttpMetricExporter getDefault() {
        return OtlpHttpMetricExporter.builder().build();
    }

    public CompletableResultCode shutdown() {
        CompletableResultCode result = CompletableResultCode.ofSuccess();
        this.client.dispatcher().cancelAll();
        return result;
    }
}

