/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.javaagent.bootstrap.IndyBootstrapDispatcher;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.AdviceBootstrapState;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.IndyModuleRegistry;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.IndyProxyFactory;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.InstrumentationModuleClassLoader;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.utility.JavaConstant;

public class IndyBootstrap {
    private static final Logger logger = Logger.getLogger(IndyBootstrap.class.getName());
    private static final Method indyBootstrapMethod;
    private static final String BOOTSTRAP_KIND_ADVICE = "advice";
    private static final String BOOTSTRAP_KIND_PROXY = "proxy";
    private static final String PROXY_KIND_STATIC = "static";
    private static final String PROXY_KIND_CONSTRUCTOR = "constructor";
    private static final String PROXY_KIND_VIRTUAL = "virtual";

    private IndyBootstrap() {
    }

    public static Method getIndyBootstrapMethod() {
        return indyBootstrapMethod;
    }

    @Nullable
    private static CallSite bootstrap(MethodHandles.Lookup lookup, String adviceMethodName, MethodType adviceMethodType, Object[] args) {
        if (System.getSecurityManager() == null) {
            return IndyBootstrap.internalBootstrap(lookup, adviceMethodName, adviceMethodType, args);
        }
        return AccessController.doPrivileged(() -> IndyBootstrap.internalBootstrap(lookup, adviceMethodName, adviceMethodType, args));
    }

    private static CallSite internalBootstrap(MethodHandles.Lookup lookup, String adviceMethodName, MethodType adviceMethodType, Object[] args) {
        try {
            String kind;
            switch (kind = (String)args[0]) {
                case "advice": {
                    return IndyBootstrap.bootstrapAdvice(lookup, adviceMethodName, adviceMethodType, (String)args[1], (String)args[2], (String)args[3]);
                }
                case "proxy": {
                    return IndyBootstrap.bootstrapProxyMethod(lookup, adviceMethodName, adviceMethodType, (String)args[1], (String)args[2], (String)args[3]);
                }
            }
            throw new IllegalArgumentException("Unknown bootstrapping kind: " + kind);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private static CallSite bootstrapAdvice(MethodHandles.Lookup lookup, String adviceMethodName, MethodType invokedynamicMethodType, String moduleClassName, String adviceMethodDescriptor, String adviceClassName) throws NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        try (AdviceBootstrapState nestedState = AdviceBootstrapState.enter(lookup.lookupClass(), moduleClassName, adviceClassName, adviceMethodName, adviceMethodDescriptor);){
            if (nestedState.isNestedInvocation()) {
                MutableCallSite mutableCallSite = nestedState.getMutableCallSite();
                if (mutableCallSite == null) {
                    mutableCallSite = new MutableCallSite(IndyBootstrapDispatcher.generateNoopMethodHandle((MethodType)invokedynamicMethodType));
                    nestedState.initMutableCallSite(mutableCallSite);
                }
                MutableCallSite mutableCallSite2 = mutableCallSite;
                return mutableCallSite2;
            }
            InstrumentationModuleClassLoader instrumentationClassloader = IndyModuleRegistry.getInstrumentationClassLoader(moduleClassName, lookup.lookupClass().getClassLoader());
            Class<?> adviceClass = instrumentationClassloader.loadClass(adviceClassName);
            MethodType actualAdviceMethodType = MethodType.fromMethodDescriptorString(adviceMethodDescriptor, instrumentationClassloader);
            MethodHandle methodHandle = instrumentationClassloader.getLookup().findStatic(adviceClass, adviceMethodName, actualAdviceMethodType).asType(invokedynamicMethodType);
            MutableCallSite nestedBootstrapCallSite = nestedState.getMutableCallSite();
            if (nestedBootstrapCallSite != null) {
                logger.log(Level.FINE, "Fixing nested instrumentation invokedynamic instruction bootstrapping for instrumented class {0} and advice {1}.{2}, the instrumentation should be active now", new Object[]{lookup.lookupClass().getName(), adviceClassName, adviceMethodName});
                nestedBootstrapCallSite.setTarget(methodHandle);
                MutableCallSite.syncAll(new MutableCallSite[]{nestedBootstrapCallSite});
                MutableCallSite mutableCallSite = nestedBootstrapCallSite;
                return mutableCallSite;
            }
            ConstantCallSite constantCallSite = new ConstantCallSite(methodHandle);
            return constantCallSite;
        }
    }

    static Advice.BootstrapArgumentResolver.Factory getAdviceBootstrapArguments(InstrumentationModule instrumentationModule) {
        String moduleName = instrumentationModule.getClass().getName();
        return (adviceMethod, exit) -> (instrumentedType, instrumentedMethod) -> Arrays.asList(JavaConstant.Simple.ofLoaded((Object)BOOTSTRAP_KIND_ADVICE), JavaConstant.Simple.ofLoaded((Object)moduleName), JavaConstant.Simple.ofLoaded((Object)adviceMethod.getDescriptor()), JavaConstant.Simple.ofLoaded((Object)adviceMethod.getDeclaringType().getName()));
    }

    private static ConstantCallSite bootstrapProxyMethod(MethodHandles.Lookup lookup, String proxyMethodName, MethodType expectedMethodType, String moduleClassName, String proxyClassName, String methodKind) throws NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        MethodHandle target;
        InstrumentationModuleClassLoader instrumentationClassloader = IndyModuleRegistry.getInstrumentationClassLoader(moduleClassName, lookup.lookupClass().getClassLoader());
        Class<?> proxiedClass = instrumentationClassloader.loadClass(proxyClassName);
        switch (methodKind) {
            case "static": {
                target = MethodHandles.publicLookup().findStatic(proxiedClass, proxyMethodName, expectedMethodType);
                break;
            }
            case "constructor": {
                target = MethodHandles.publicLookup().findConstructor(proxiedClass, expectedMethodType.changeReturnType(Void.TYPE)).asType(expectedMethodType);
                break;
            }
            case "virtual": {
                target = MethodHandles.publicLookup().findVirtual(proxiedClass, proxyMethodName, expectedMethodType.dropParameterTypes(0, 1)).asType(expectedMethodType);
                break;
            }
            default: {
                throw new IllegalStateException("unknown proxy method kind: " + methodKind);
            }
        }
        return new ConstantCallSite(target);
    }

    public static IndyProxyFactory getProxyFactory(InstrumentationModule instrumentationModule) {
        String moduleName = instrumentationModule.getClass().getName();
        return new IndyProxyFactory(IndyBootstrap.getIndyBootstrapMethod(), (proxiedType, proxiedMethod) -> {
            String methodKind;
            if (proxiedMethod.isConstructor()) {
                methodKind = PROXY_KIND_CONSTRUCTOR;
            } else if (proxiedMethod.isMethod()) {
                methodKind = proxiedMethod.isStatic() ? PROXY_KIND_STATIC : PROXY_KIND_VIRTUAL;
            } else {
                throw new IllegalArgumentException("Unknown type of method: " + proxiedMethod.getName());
            }
            return Arrays.asList(JavaConstant.Simple.ofLoaded((Object)BOOTSTRAP_KIND_PROXY), JavaConstant.Simple.ofLoaded((Object)moduleName), JavaConstant.Simple.ofLoaded((Object)proxiedType.getName()), JavaConstant.Simple.ofLoaded((Object)methodKind));
        });
    }

    static {
        try {
            indyBootstrapMethod = IndyBootstrapDispatcher.class.getMethod("bootstrap", MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class);
            MethodType bootstrapMethodType = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class);
            IndyBootstrapDispatcher.init((MethodHandle)MethodHandles.lookup().findStatic(IndyBootstrap.class, "bootstrap", bootstrapMethodType));
            AdviceBootstrapState.initialize();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

