/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.config;

import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.tooling.config.ConfigurationPropertiesSupplier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class ConfigurationFile {
    static final String CONFIGURATION_FILE_PROPERTY = "otel.javaagent.configuration-file";
    private static Map<String, String> configFileContents;
    @Nullable
    private static String fileLoadErrorMessage;

    static Map<String, String> getProperties() {
        if (configFileContents == null) {
            configFileContents = ConfigurationFile.loadConfigFile();
        }
        return configFileContents;
    }

    static void resetForTest() {
        configFileContents = null;
    }

    static Map<String, String> loadConfigFile() {
        String configurationFilePath = ConfigPropertiesUtil.getString((String)CONFIGURATION_FILE_PROPERTY);
        if (configurationFilePath == null) {
            return Collections.emptyMap();
        }
        File configurationFile = new File(configurationFilePath = configurationFilePath.replaceFirst("^~", System.getProperty("user.home")));
        if (!configurationFile.exists()) {
            fileLoadErrorMessage = "Configuration file \"" + configurationFilePath + "\" not found.";
            return Collections.emptyMap();
        }
        Properties properties = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configurationFile), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        catch (FileNotFoundException fnf) {
            fileLoadErrorMessage = "Configuration file \"" + configurationFilePath + "\" not found.";
        }
        catch (IOException ioe) {
            fileLoadErrorMessage = "Configuration file \"" + configurationFilePath + "\" cannot be accessed or correctly parsed.";
        }
        return properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
    }

    static void logErrorIfAny() {
        if (fileLoadErrorMessage != null) {
            Logger.getLogger(ConfigurationPropertiesSupplier.class.getName()).log(Level.SEVERE, fileLoadErrorMessage);
        }
    }

    private ConfigurationFile() {
    }
}

