/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.tooling.InputStreamUrlConnection;
import io.opentelemetry.javaagent.tooling.RemappingUrlConnection;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class RemappingUrlStreamHandler
extends URLStreamHandler {
    private final JarFile delegateJarFile;

    public RemappingUrlStreamHandler(File delegateFile) {
        try {
            this.delegateJarFile = new JarFile(delegateFile, false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read internal jar", e);
        }
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        JarEntry entry;
        String file = url.getFile();
        if ("/".equals(file)) {
            return new InputStreamUrlConnection(url, new ByteArrayInputStream(new byte[0]), 0L);
        }
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        if ((entry = this.delegateJarFile.getJarEntry(file)) == null) {
            throw new FileNotFoundException("JAR entry " + file + " not found in " + this.delegateJarFile.getName());
        }
        if (file.endsWith(".class")) {
            return new RemappingUrlConnection(url, this.delegateJarFile, entry);
        }
        InputStream is = this.delegateJarFile.getInputStream(entry);
        return new InputStreamUrlConnection(url, is, entry.getSize());
    }
}

