/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.tooling.SunMiscUnsafeGenerator;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnsafeInitializer {
    private static final Logger logger = Logger.getLogger(UnsafeInitializer.class.getName());

    static void initialize(Instrumentation instrumentation, ClassLoader classLoader) {
        UnsafeInitializer.initialize(instrumentation, classLoader, true);
    }

    private static void initialize(Instrumentation instrumentation, ClassLoader classLoader, boolean testUnsafePresent) {
        Class<?> unsafeClass;
        try {
            unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
        }
        catch (ClassNotFoundException exception) {
            return;
        }
        HashMap<String, Set<Module>> exports = new HashMap<String, Set<Module>>();
        exports.put(unsafeClass.getPackage().getName(), Collections.singleton(UnsafeInitializer.class.getModule()));
        instrumentation.redefineModule(unsafeClass.getModule(), Collections.emptySet(), exports, Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap());
        if (testUnsafePresent && UnsafeInitializer.hasSunMiscUnsafe()) {
            return;
        }
        if (!(classLoader instanceof AgentClassLoader)) {
            return;
        }
        try {
            SunMiscUnsafeGenerator.generateUnsafe(unsafeClass, (AgentClassLoader)classLoader);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Unsafe generation failed", throwable);
        }
    }

    private static boolean hasSunMiscUnsafe() {
        try {
            Class.forName("sun.misc.Unsafe");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

