/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.javahttpserver;

import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpExchange;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.io.IOException;

final class OpenTelemetryFilter
extends Filter {
    private final Instrumenter<HttpExchange, HttpExchange> instrumenter;

    OpenTelemetryFilter(Instrumenter<HttpExchange, HttpExchange> instrumenter) {
        this.instrumenter = instrumenter;
    }

    @Override
    public void doFilter(HttpExchange exchange, Filter.Chain chain) throws IOException {
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)exchange)) {
            chain.doFilter(exchange);
            return;
        }
        Context context = this.instrumenter.start(parentContext, (Object)exchange);
        Throwable error = null;
        try (Scope ignored = context.makeCurrent();){
            chain.doFilter(exchange);
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            this.instrumenter.end(context, (Object)exchange, (Object)exchange, error);
        }
    }

    @Override
    public String description() {
        return "OpenTelemetry tracing filter";
    }
}

