/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.javahttpserver;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sun.net.httpserver.HttpExchange;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpServerInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.javahttpserver.JavaHttpServerAttributesGetter;
import io.opentelemetry.instrumentation.javahttpserver.JavaHttpServerExchangeGetter;
import io.opentelemetry.instrumentation.javahttpserver.JavaHttpServerTelemetry;
import io.opentelemetry.instrumentation.javahttpserver.internal.Experimental;
import io.opentelemetry.instrumentation.javahttpserver.internal.JavaHttpServerInstrumenterBuilderUtil;
import java.util.Collection;
import java.util.function.Function;

public final class JavaHttpServerTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.java-http-server";
    private final DefaultHttpServerInstrumenterBuilder<HttpExchange, HttpExchange> builder;

    JavaHttpServerTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.builder = DefaultHttpServerInstrumenterBuilder.create((String)INSTRUMENTATION_NAME, (OpenTelemetry)openTelemetry, (HttpServerAttributesGetter)JavaHttpServerAttributesGetter.INSTANCE, (TextMapGetter)JavaHttpServerExchangeGetter.INSTANCE);
    }

    @CanIgnoreReturnValue
    public JavaHttpServerTelemetryBuilder setStatusExtractor(Function<SpanStatusExtractor<? super HttpExchange, ? super HttpExchange>, ? extends SpanStatusExtractor<? super HttpExchange, ? super HttpExchange>> statusExtractor) {
        this.builder.setStatusExtractor(statusExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public JavaHttpServerTelemetryBuilder addAttributesExtractor(AttributesExtractor<HttpExchange, HttpExchange> attributesExtractor) {
        this.builder.addAttributesExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public JavaHttpServerTelemetryBuilder setCapturedRequestHeaders(Collection<String> requestHeaders) {
        this.builder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public JavaHttpServerTelemetryBuilder setCapturedResponseHeaders(Collection<String> responseHeaders) {
        this.builder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public JavaHttpServerTelemetryBuilder setKnownMethods(Collection<String> knownMethods) {
        this.builder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public JavaHttpServerTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<? super HttpExchange>, ? extends SpanNameExtractor<? super HttpExchange>> serverSpanNameExtractor) {
        this.builder.setSpanNameExtractor(serverSpanNameExtractor);
        return this;
    }

    public JavaHttpServerTelemetry build() {
        return new JavaHttpServerTelemetry((Instrumenter<HttpExchange, HttpExchange>)this.builder.build());
    }

    static {
        JavaHttpServerInstrumenterBuilderUtil.setServerBuilderExtractor(builder -> builder.builder);
        Experimental.internalSetEmitExperimentalTelemetry((builder, emit) -> builder.builder.setEmitExperimentalHttpServerMetrics(emit.booleanValue()));
    }
}

