/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.javahttpserver;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsExchange;
import io.opentelemetry.instrumentation.api.internal.HttpProtocolUtil;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

enum JavaHttpServerAttributesGetter implements HttpServerAttributesGetter<HttpExchange, HttpExchange>
{
    INSTANCE;


    public String getHttpRequestMethod(HttpExchange exchange) {
        return exchange.getRequestMethod();
    }

    public String getUrlScheme(HttpExchange exchange) {
        return exchange instanceof HttpsExchange ? "https" : "http";
    }

    public String getUrlPath(HttpExchange exchange) {
        return exchange.getRequestURI().getPath();
    }

    @Nullable
    public String getUrlQuery(HttpExchange exchange) {
        return exchange.getRequestURI().getQuery();
    }

    public List<String> getHttpRequestHeader(HttpExchange exchange, String name) {
        return exchange.getRequestHeaders().getOrDefault(name, Collections.emptyList());
    }

    @Nullable
    public Integer getHttpResponseStatusCode(HttpExchange exchange, @Nullable HttpExchange res, @Nullable Throwable error) {
        int status = exchange.getResponseCode();
        return status != -1 ? Integer.valueOf(status) : null;
    }

    public List<String> getHttpResponseHeader(HttpExchange exchange, @Nullable HttpExchange res, String name) {
        return exchange.getResponseHeaders().getOrDefault(name, Collections.emptyList());
    }

    public String getHttpRoute(HttpExchange exchange) {
        return exchange.getHttpContext().getPath();
    }

    public String getNetworkProtocolName(HttpExchange exchange, @Nullable HttpExchange res) {
        return HttpProtocolUtil.getProtocol((String)exchange.getProtocol());
    }

    public String getNetworkProtocolVersion(HttpExchange exchange, @Nullable HttpExchange res) {
        return HttpProtocolUtil.getVersion((String)exchange.getProtocol());
    }

    public InetSocketAddress getNetworkPeerInetSocketAddress(HttpExchange exchange, @Nullable HttpExchange res) {
        return exchange.getRemoteAddress();
    }

    public InetSocketAddress getNetworkLocalInetSocketAddress(HttpExchange exchange, @Nullable HttpExchange res) {
        return exchange.getLocalAddress();
    }
}

