/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.prometheus.clientbridge;

import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class Serializer {
    static double getBucketLowerBound(HistogramPointData point, int bucketIndex) {
        return bucketIndex > 0 ? (Double)point.getBoundaries().get(bucketIndex - 1) : Double.NEGATIVE_INFINITY;
    }

    static double getBucketUpperBound(HistogramPointData point, int bucketIndex) {
        List boundaries = point.getBoundaries();
        return bucketIndex < boundaries.size() ? (Double)boundaries.get(bucketIndex) : Double.POSITIVE_INFINITY;
    }

    static Collection<? extends PointData> getPoints(MetricData metricData) {
        switch (metricData.getType()) {
            case DOUBLE_GAUGE: {
                return metricData.getDoubleGaugeData().getPoints();
            }
            case DOUBLE_SUM: {
                return metricData.getDoubleSumData().getPoints();
            }
            case LONG_GAUGE: {
                return metricData.getLongGaugeData().getPoints();
            }
            case LONG_SUM: {
                return metricData.getLongSumData().getPoints();
            }
            case SUMMARY: {
                return metricData.getSummaryData().getPoints();
            }
            case HISTOGRAM: {
                return metricData.getHistogramData().getPoints();
            }
            case EXPONENTIAL_HISTOGRAM: {
                return metricData.getExponentialHistogramData().getPoints();
            }
        }
        return Collections.emptyList();
    }

    private Serializer() {
    }
}

