/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.webhook;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.camel.builder.RouteBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientBuilderImpl;
import org.openremote.container.util.MapAccess;
import org.openremote.container.web.WebTargetBuilder;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.webhook.Webhook;

public class WebhookService
extends RouteBuilder
implements ContainerService {
    private static final Logger LOG = Logger.getLogger(WebhookService.class.getName());
    protected ResteasyClientBuilder clientBuilder;
    public static final String WEBHOOK_CONNECT_TIMEOUT = "WEBHOOK_CONNECT_TIMEOUT";
    public static final int WEBHOOK_CONNECT_TIMEOUT_DEFAULT = 2000;
    public static final String WEBHOOK_REQUEST_TIMEOUT = "WEBHOOK_REQUEST_TIMEOUT";
    public static final int WEBHOOK_REQUEST_TIMEOUT_DEFAULT = 10000;

    public void init(Container container) throws Exception {
        this.clientBuilder = new ResteasyClientBuilderImpl().connectTimeout((long)MapAccess.getInteger((Map)container.getConfig(), (String)WEBHOOK_CONNECT_TIMEOUT, (int)2000), TimeUnit.MILLISECONDS).readTimeout((long)MapAccess.getInteger((Map)container.getConfig(), (String)WEBHOOK_REQUEST_TIMEOUT, (int)10000), TimeUnit.MILLISECONDS);
    }

    public void configure() throws Exception {
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendHttpRequest(Webhook webhook, MediaType mediaType, WebTarget target) {
        try (Response response = this.buildRequest(webhook, target, mediaType);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                LOG.warning("Webhook request responded with error " + response.getStatus() + ": " + response.getStatusInfo().getReasonPhrase());
                return false;
            }
            LOG.info("Webhook request executed successfully with response status " + response.getStatus());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
        }
        return false;
    }

    public WebTarget buildWebTarget(Webhook webhook) {
        ResteasyClient client = this.clientBuilder.build();
        WebTargetBuilder builder = new WebTargetBuilder(client, URI.create(webhook.getUrl()));
        if (webhook.getUsernamePassword() != null) {
            builder.setBasicAuthentication(webhook.getUsernamePassword().getUsername(), webhook.getUsernamePassword().getPassword());
        } else if (webhook.getOAuthGrant() != null) {
            builder.setOAuthAuthentication(webhook.getOAuthGrant());
        }
        return builder.build();
    }

    private Response buildRequest(Webhook webhook, WebTarget target, MediaType mediaType) throws ProcessingException {
        Invocation.Builder request = target.request();
        if (webhook.getHeaders() != null) {
            request = WebTargetBuilder.addHeaders((Invocation.Builder)request, (Map)webhook.getHeaders());
        }
        String payload = webhook.getPayload();
        return request.method(webhook.getHttpMethod().name(), payload != null ? Entity.entity((Object)payload, (MediaType)mediaType) : null);
    }
}

