/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.web;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.util.HttpString;
import io.undertow.util.RedirectBuilder;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.openremote.container.security.IdentityService;
import org.openremote.container.util.MapAccess;
import org.openremote.container.web.WebService;
import org.openremote.manager.web.ManagerFileServlet;
import org.openremote.model.Container;
import org.openremote.model.util.ValueUtil;

public class ManagerWebService
extends WebService {
    public static final int PRIORITY = 2147482747;
    public static final String OR_APP_DOCROOT = "OR_APP_DOCROOT";
    public static final String OR_APP_DOCROOT_DEFAULT = "ui/app";
    public static final String OR_CUSTOM_APP_DOCROOT = "OR_CUSTOM_APP_DOCROOT";
    public static final String OR_CUSTOM_APP_DOCROOT_DEFAULT = "deployment/manager/app";
    public static final String OR_ROOT_REDIRECT_PATH = "OR_ROOT_REDIRECT_PATH";
    public static final String OR_ROOT_REDIRECT_PATH_DEFAULT = "/manager";
    public static final String API_PATH = "/api";
    public static final String MANAGER_APP_PATH = "/manager";
    public static final String INSIGHTS_APP_PATH = "/insights";
    public static final String SWAGGER_APP_PATH = "/swagger";
    public static final String CONSOLE_LOADER_APP_PATH = "/console_loader";
    public static final String SHARED_PATH = "/shared";
    public static final List<String> APP_PATHS = List.of("/manager", "/insights", "/swagger", "/console_loader", "/shared");
    public static final String UI_CLASSPATH_PREFIX = "org/openremote/web";
    private static final Logger LOG = Logger.getLogger(ManagerWebService.class.getName());
    protected static final Pattern PATTERN_REALM_SUB = Pattern.compile("/([a-zA-Z0-9\\-_]+)/(.*)");
    protected boolean initialised;
    protected Path builtInAppDocRoot;
    protected Path customAppDocRoot;
    protected Collection<Class<?>> apiClasses = new HashSet();
    protected Collection<Object> apiSingletons = new HashSet<Object>();

    public int getPriority() {
        return 2147482747;
    }

    public void init(Container container) throws Exception {
        super.init(container);
        String rootRedirectPath = MapAccess.getString((Map)container.getConfig(), (String)OR_ROOT_REDIRECT_PATH, (String)"/manager");
        this.addOpenApiResource();
        this.initialised = true;
        ResteasyDeployment resteasyDeployment = this.createResteasyDeployment(container, this.getApiClasses(), this.apiSingletons, true);
        HttpHandler apiHandler = this.createApiHandler(container, resteasyDeployment);
        if (apiHandler != null) {
            HttpHandler baseApiHandler = apiHandler;
            apiHandler = exchange -> {
                String path = exchange.getRelativePath().substring(API_PATH.length());
                Matcher realmSubMatcher = PATTERN_REALM_SUB.matcher(path);
                if (!realmSubMatcher.matches()) {
                    exchange.setStatusCode(Response.Status.NOT_FOUND.getStatusCode());
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
                String realm = realmSubMatcher.group(1);
                exchange.getRequestHeaders().put(HttpString.tryFromString((String)"Realm"), realm);
                URI url = UriBuilder.fromUri((String)exchange.getRequestURL()).replacePath(realmSubMatcher.group(2)).build(new Object[0]);
                exchange.setRequestURI(url.toString(), true);
                exchange.setRequestPath(url.getPath());
                exchange.setRelativePath(url.getPath());
                baseApiHandler.handleRequest(exchange);
            };
        }
        this.builtInAppDocRoot = Paths.get(MapAccess.getString((Map)container.getConfig(), (String)OR_APP_DOCROOT, (String)OR_APP_DOCROOT_DEFAULT), new String[0]);
        this.customAppDocRoot = Paths.get(MapAccess.getString((Map)container.getConfig(), (String)OR_CUSTOM_APP_DOCROOT, (String)OR_CUSTOM_APP_DOCROOT_DEFAULT), new String[0]);
        HttpHandler defaultHandler = null;
        if (Files.isDirectory(this.customAppDocRoot, new LinkOption[0])) {
            HttpHandler customBaseFileHandler = ManagerWebService.createFileHandler(container, (ResourceManager)new PathResourceManager(this.customAppDocRoot), null);
            defaultHandler = exchange -> {
                if (exchange.getRelativePath().isEmpty() || "/".equals(exchange.getRelativePath())) {
                    exchange.setRelativePath("/index.html");
                }
                customBaseFileHandler.handleRequest(exchange);
            };
        }
        PathHandler deploymentHandler = defaultHandler != null ? new PathHandler(defaultHandler) : new PathHandler();
        this.serveFilesFromBuiltInAppDocRoot(container, deploymentHandler);
        this.serveFilesFromClassPath(container, deploymentHandler);
        if (rootRedirectPath != null) {
            this.getRequestHandlers().add(new WebService.RequestHandler("Default app redirect", exchange -> exchange.getRequestPath().equals("/"), exchange -> {
                LOG.finest("Handling root request, redirecting client to default app");
                new RedirectHandler(RedirectBuilder.redirect((HttpServerExchange)exchange, (String)rootRedirectPath)).handleRequest(exchange);
            }));
        }
        if (apiHandler != null) {
            this.getRequestHandlers().add(ManagerWebService.pathStartsWithHandler((String)"REST API Handler", (String)API_PATH, (HttpHandler)apiHandler));
        }
        this.getRequestHandlers().add(new WebService.RequestHandler("Deployment files", exchange -> true, (HttpHandler)deploymentHandler));
    }

    private void addOpenApiResource() {
        ValueUtil.configureObjectMapper((ObjectMapper)Json.mapper());
        Json.mapper().addMixIn(StringSchema.class, StringSchemaMixin.class);
        Json.mapper().addMixIn(ServerVariable.class, ServerVariableMixin.class);
        OpenAPI oas = new OpenAPI().servers(List.of(new Server().url("/api/{realm}/").variables(new ServerVariables().addServerVariable("realm", new ServerVariable()._default("master"))))).schemaRequirement("openid", new SecurityScheme().type(SecurityScheme.Type.OAUTH2).flows(new OAuthFlows().authorizationCode(new OAuthFlow().authorizationUrl("/auth/realms/master/protocol/openid-connect/auth").refreshUrl("/auth/realms/master/protocol/openid-connect/token").tokenUrl("/auth/realms/master/protocol/openid-connect/token").scopes(new Scopes().addString("profile", "profile"))).clientCredentials(new OAuthFlow().tokenUrl("/auth/realms/master/protocol/openid-connect/token").refreshUrl("/auth/realms/master/protocol/openid-connect/token").scopes(new Scopes().addString("profile", "profile"))))).security(List.of(new SecurityRequirement().addList("openid")));
        Info info = new Info().title("OpenRemote Manager REST API").version("3.0.0").description("This is the documentation for the OpenRemote Manager HTTP REST API.  Please see the [documentation](https://docs.openremote.io) for more info.").contact(new Contact().email("info@openremote.io")).license(new License().name("AGPL 3.0").url("https://www.gnu.org/licenses/agpl-3.0.en.html"));
        oas.info(info);
        SwaggerConfiguration oasConfig = new SwaggerConfiguration().resourcePackages(Set.of("org.openremote.model.*")).openAPI(oas);
        OpenApiResource openApiResource = new OpenApiResource();
        openApiResource.openApiConfiguration((OpenAPIConfiguration)oasConfig);
        this.addApiSingleton(openApiResource);
    }

    protected void serveFilesFromBuiltInAppDocRoot(Container container, PathHandler deploymentHandler) {
        if (Files.isDirectory(this.builtInAppDocRoot, new LinkOption[0])) {
            HttpHandler appBaseFileHandler = ManagerWebService.createFileHandler(container, (ResourceManager)new PathResourceManager(this.builtInAppDocRoot), null);
            HttpHandler appFileHandler = exchange -> {
                if (exchange.getRelativePath().isEmpty() || "/".equals(exchange.getRelativePath())) {
                    exchange.setRelativePath("/index.html");
                }
                exchange.setRelativePath(exchange.getRequestPath());
                appBaseFileHandler.handleRequest(exchange);
            };
            APP_PATHS.forEach(path -> {
                Path diskPath = this.builtInAppDocRoot.resolve(path.substring(1));
                if (Files.isDirectory(diskPath, new LinkOption[0])) {
                    deploymentHandler.addPrefixPath(path, appFileHandler);
                    LOG.info("Serving " + path + " from disk: " + String.valueOf(diskPath.toAbsolutePath()));
                }
            });
        }
    }

    protected void serveFilesFromClassPath(Container container, PathHandler deploymentHandler) {
        HttpHandler classPathFileHandler = ManagerWebService.createFileHandler(container, (ResourceManager)new ClassPathResourceManager(ManagerWebService.class.getClassLoader(), UI_CLASSPATH_PREFIX), null);
        HttpHandler appFileHandler = exchange -> {
            if (exchange.getRelativePath().isEmpty() || "/".equals(exchange.getRelativePath())) {
                exchange.setRelativePath("index.html");
            }
            exchange.setRelativePath(exchange.getRequestPath());
            classPathFileHandler.handleRequest(exchange);
        };
        APP_PATHS.forEach(path -> {
            URL url = ManagerWebService.class.getClassLoader().getResource(UI_CLASSPATH_PREFIX + path);
            if (url != null) {
                deploymentHandler.addPrefixPath(path, appFileHandler);
                LOG.info("Serving " + path + " from classpath: " + String.valueOf(url));
            }
        });
    }

    public Collection<Class<?>> getApiClasses() {
        return this.apiClasses;
    }

    public void addApiSingleton(Object singleton) {
        if (this.initialised) {
            throw new IllegalStateException("API singletons must be added before the service is initialised");
        }
        this.apiSingletons.add(singleton);
    }

    public Path getBuiltInAppDocRoot() {
        return this.builtInAppDocRoot;
    }

    public Path getCustomAppDocRoot() {
        return this.customAppDocRoot;
    }

    protected HttpHandler createApiHandler(Container container, ResteasyDeployment resteasyDeployment) {
        if (resteasyDeployment == null) {
            return null;
        }
        ServletInfo restServlet = Servlets.servlet((String)"RESTEasy Servlet", HttpServlet30Dispatcher.class).setAsyncSupported(true).setLoadOnStartup(Integer.valueOf(1)).addMapping("/*");
        DeploymentInfo deploymentInfo = new DeploymentInfo().setDeploymentName("RESTEasy Deployment").setContextPath(API_PATH).addServletContextAttribute(ResteasyDeployment.class.getName(), (Object)resteasyDeployment).addServlet(restServlet).setClassLoader(Container.class.getClassLoader());
        IdentityService identityService = (IdentityService)container.getService(IdentityService.class);
        if (identityService == null) {
            throw new RuntimeException("No identity service deployed, can't enable API security");
        }
        resteasyDeployment.setSecurityEnabled(true);
        return ManagerWebService.addServletDeployment((Container)container, (DeploymentInfo)deploymentInfo, (boolean)resteasyDeployment.isSecurityEnabled());
    }

    public static HttpHandler createFileHandler(Container container, ResourceManager resourceManager, String[] requiredRoles) {
        boolean devMode = container.isDevMode();
        requiredRoles = requiredRoles == null ? new String[]{} : requiredRoles;
        DeploymentInfo deploymentInfo = ManagerFileServlet.createDeploymentInfo(devMode, "", resourceManager, requiredRoles);
        return new CanonicalPathHandler(ManagerWebService.addServletDeployment((Container)container, (DeploymentInfo)deploymentInfo, (requiredRoles.length != 0 ? 1 : 0) != 0));
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{builtInAppDocRoot=" + String.valueOf(this.builtInAppDocRoot) + ", customAppDocRoot=" + String.valueOf(this.customAppDocRoot) + "}";
    }

    private static abstract class StringSchemaMixin {
        @JsonProperty(value="enum")
        protected List<String> _enum;

        private StringSchemaMixin() {
        }
    }

    private static abstract class ServerVariableMixin {
        @JsonProperty(value="default")
        List<String> _default;

        private ServerVariableMixin() {
        }
    }
}

