/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.web;

import org.openremote.container.timer.TimerService;
import org.openremote.container.web.WebResource;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.model.security.Realm;

public class ManagerWebResource
extends WebResource {
    protected final TimerService timerService;
    protected final ManagerIdentityService identityService;

    public ManagerWebResource(TimerService timerService, ManagerIdentityService identityService) {
        this.timerService = timerService;
        this.identityService = identityService;
    }

    public boolean isRestrictedUser() {
        return this.isAuthenticated() && this.identityService.getIdentityProvider().isRestrictedUser(this.getAuthContext());
    }

    public Realm getAuthenticatedRealm() {
        return this.identityService.getIdentityProvider().getRealm(this.getAuthenticatedRealmName());
    }

    public Realm getRequestRealm() {
        return this.identityService.getIdentityProvider().getRealm(this.getRequestRealmName());
    }

    public boolean isRealmActiveAndAccessible(String realm) {
        return this.identityService.getIdentityProvider().isRealmActiveAndAccessible(this.getAuthContext(), realm);
    }

    public boolean isRealmActiveAndAccessible(Realm realm) {
        return this.identityService.getIdentityProvider().isRealmActiveAndAccessible(this.getAuthContext(), realm);
    }
}

