/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.web;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openremote.container.web.file.FileServlet;
import org.openremote.container.web.file.GzipResponseFilter;
import org.openremote.model.Container;

public class ManagerFileServlet
extends FileServlet {
    private static final Logger LOG = Logger.getLogger(ManagerFileServlet.class.getName());
    public static final Map<String, String> MIME_TYPES = new HashMap<String, String>(){
        {
            this.put("pbf", "application/x-protobuf");
            this.put("woff2", "font/woff2");
            this.put("wsdl", "application/xml");
            this.put("xsl", "text/xsl");
        }
    };
    public static final String[] FILE_EXTENSIONS_ALREADY_ZIPPED = new String[]{".pbf"};
    public static final Map<String, Integer> MIME_TYPES_EXPIRE_SECONDS = new HashMap<String, Integer>(){
        {
            this.put("image/png", 43200);
            this.put("image/jpg", 43200);
            this.put("text/html", 0);
            this.put("text/xml", 1800);
            this.put("text/css", 1800);
            this.put("text/javascript", 43200);
            this.put("application/javascript", 43200);
            this.put("application/json", 1800);
            this.put("application/font-woff2", 43200);
            this.put("application/x-protobuf", 43200);
        }
    };
    public static final String[] MIME_TYPES_TO_ZIP = new String[]{"text/plain", "text/html", "text/xml", "text/css", "text/javascript", "text/csv", "text/rtf", "application/xml", "application/xhtml+xml", "application/javascript", "application/json", "image/svg+xml"};

    public ManagerFileServlet(boolean devMode, ResourceManager resourceManager, String[] requiredRoles) {
        super(devMode, resourceManager, requiredRoles, MIME_TYPES, MIME_TYPES_EXPIRE_SECONDS, FILE_EXTENSIONS_ALREADY_ZIPPED);
    }

    public static DeploymentInfo createDeploymentInfo(boolean devMode, String contextPath, ResourceManager resourceManager, String[] requiredRoles) {
        ManagerFileServlet fileServlet = new ManagerFileServlet(devMode, resourceManager, requiredRoles);
        ServletInfo servletInfo = Servlets.servlet((String)"Manager File Servlet", FileServlet.class, () -> new ImmediateInstanceHandle((Object)fileServlet));
        servletInfo.addMapping("/*");
        GzipResponseFilter gzipFilter = new GzipResponseFilter(MIME_TYPES_TO_ZIP);
        FilterInfo gzipFilterInfo = Servlets.filter((String)"Gzip Filter", GzipResponseFilter.class, () -> ManagerFileServlet.lambda$createDeploymentInfo$1((Filter)gzipFilter)).setAsyncSupported(true);
        return new DeploymentInfo().setDeploymentName(contextPath + " File Servlet Deployment").setContextPath(contextPath).addServlet(servletInfo).addFilter(gzipFilterInfo).addFilterUrlMapping(gzipFilterInfo.getName(), "/*", DispatcherType.REQUEST).setClassLoader(Container.class.getClassLoader());
    }

    public static HttpHandler wrapHandler(HttpHandler wrapped, Pattern requestPattern) {
        return exchange -> {
            String requestPath = exchange.getRequestPath();
            Matcher staticMatcher = requestPattern.matcher(requestPath);
            if (staticMatcher.matches()) {
                LOG.finest("Serving static resource: " + requestPath);
                String remaining = staticMatcher.group(1);
                String relativePath = remaining == null || remaining.isEmpty() ? "/" : remaining;
                exchange.setRelativePath(relativePath);
                wrapped.handleRequest(exchange);
            }
        };
    }

    private static /* synthetic */ InstanceHandle lambda$createDeploymentInfo$1(Filter gzipFilter) throws InstantiationException {
        return new ImmediateInstanceHandle((Object)gzipFilter);
    }
}

