/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.system;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import org.openremote.model.Container;
import org.openremote.model.system.HealthStatusProvider;

public class SystemHealthStatusProvider
implements HealthStatusProvider {
    public static final String NAME = "system";

    public void init(Container container) throws Exception {
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public String getHealthStatusName() {
        return NAME;
    }

    public Object getHealthStatus() {
        HashMap<String, Serializable> objectValue = new HashMap<String, Serializable>();
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        File[] roots = File.listRoots();
        objectValue.put("systemLoadPercentage", Double.valueOf(operatingSystemMXBean.getCpuLoad() * 100.0));
        objectValue.put("totalPhysicalMemoryMB", Float.valueOf((float)operatingSystemMXBean.getTotalMemorySize() / 1048576.0f));
        objectValue.put("freePhysicalMemoryMB", Float.valueOf((float)operatingSystemMXBean.getFreeMemorySize() / 1048576.0f));
        objectValue.put("committedVirtualMemoryMB", Float.valueOf((float)operatingSystemMXBean.getCommittedVirtualMemorySize() / 1048576.0f));
        objectValue.put("totalSwapSpaceMB", Float.valueOf((float)operatingSystemMXBean.getTotalSwapSpaceSize() / 1048576.0f));
        objectValue.put("freeSwapSpaceMB", Float.valueOf((float)operatingSystemMXBean.getFreeSwapSpaceSize() / 1048576.0f));
        HashMap rootsObj = new HashMap();
        for (File root : roots) {
            HashMap<String, Float> rootObj = new HashMap<String, Float>();
            rootObj.put("totalSpaceMB", Float.valueOf((float)root.getTotalSpace() / 1048576.0f));
            rootObj.put("freeSpaceMB", Float.valueOf((float)root.getFreeSpace() / 1048576.0f));
            String name = root.getAbsolutePath();
            name = name.replace("/", "").replace("\\", "").replace(":", "");
            rootsObj.put(name, rootObj);
        }
        objectValue.put("filesystem", rootsObj);
        return objectValue;
    }
}

