/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.system;

import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.model.Container;
import org.openremote.model.system.HealthStatusProvider;
import org.openremote.model.system.StatusResource;

public class StatusResourceImpl
implements StatusResource {
    private static final Logger LOG = Logger.getLogger(StatusResourceImpl.class.getName());
    protected List<HealthStatusProvider> healthStatusProviderList;
    protected Map<String, Object> serverInfo;

    public StatusResourceImpl(Container container, List<HealthStatusProvider> healthStatusProviderList) {
        this.healthStatusProviderList = healthStatusProviderList;
        Properties versionProps = new Properties();
        String authServerUrl = "";
        String version = null;
        ManagerIdentityService identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        if (identityService != null && identityService.getIdentityProvider().getFrontendURI() != null) {
            authServerUrl = identityService.getIdentityProvider().getFrontendURI();
        }
        try (InputStream resourceStream = StatusResourceImpl.class.getClassLoader().getResourceAsStream("version.properties");){
            if (resourceStream != null) {
                versionProps.load(resourceStream);
                version = versionProps.getProperty("version");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (version == null) {
            LOG.log(Level.WARNING, "Failed to load manager version properties file: version.properties");
            version = "0.0.0";
        }
        this.serverInfo = Map.of("version", version, "authServerUrl", authServerUrl);
    }

    public Map<String, Object> getHealthStatus() {
        HashMap<String, Object> objectValue = new HashMap<String, Object>();
        this.healthStatusProviderList.forEach(healthStatusProvider -> {
            Object healthStatus = healthStatusProvider.getHealthStatus();
            Map<String, Object> providerValue = Map.of("data", healthStatus != null ? healthStatus : NullNode.getInstance());
            objectValue.put(healthStatusProvider.getHealthStatusName(), providerValue);
        });
        return objectValue;
    }

    public Map<String, Object> getInfo() {
        return this.serverInfo;
    }
}

