/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.system;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.openremote.container.util.MapAccess;
import org.openremote.model.Container;
import org.openremote.model.system.HealthStatusProvider;

public class SslHealthStatusProvider
implements X509TrustManager,
HealthStatusProvider {
    public static final String NAME = "ssl";
    protected static final Logger LOG = Logger.getLogger(SslHealthStatusProvider.class.getName());
    protected String host;
    protected int SSLPort;
    protected SSLContext SSLContext;

    public void init(Container container) throws Exception {
        int SSLPort = MapAccess.getInteger((Map)container.getConfig(), (String)"OR_SSL_PORT", (int)-1);
        if (SSLPort < 0) {
            SSLPort = 443;
        }
        if (SSLPort > 0 && SSLPort <= 65536) {
            this.SSLPort = SSLPort;
            this.host = MapAccess.getString((Map)container.getConfig(), (String)"OR_HOSTNAME", null);
            this.SSLContext = javax.net.ssl.SSLContext.getInstance("TLS");
            this.SSLContext.init(null, new TrustManager[]{this}, null);
        }
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public String getHealthStatusName() {
        return NAME;
    }

    public Object getHealthStatus() {
        Map<String, Long> map;
        block9: {
            if (this.SSLContext == null) {
                return null;
            }
            SSLSocketFactory ssf = this.SSLContext.getSocketFactory();
            SSLSocket socket = (SSLSocket)ssf.createSocket(this.host, this.SSLPort);
            try {
                socket.startHandshake();
                X509Certificate[] peerCertificates = (X509Certificate[])socket.getSession().getPeerCertificates();
                X509Certificate serverCert = peerCertificates[0];
                Date date = serverCert.getNotAfter();
                long validDays = ChronoUnit.DAYS.between(Instant.now(), date.toInstant());
                map = Map.of("validDays", validDays);
                if (socket == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Failed to connect to SSL port " + this.SSLPort + " on host: " + this.host);
                    return null;
                }
            }
            socket.close();
        }
        return map;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

