/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.system;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import org.openremote.model.Container;
import org.openremote.model.system.HealthStatusProvider;

public class JvmHealthStatusProvider
implements HealthStatusProvider {
    public static final String NAME = "jvm";

    public void init(Container container) throws Exception {
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public String getHealthStatusName() {
        return NAME;
    }

    public Object getHealthStatus() {
        HashMap<String, Number> objectValue = new HashMap<String, Number>();
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        objectValue.put("startTimeMillis", runtimeMXBean.getStartTime());
        objectValue.put("upTimeMillis", runtimeMXBean.getUptime());
        objectValue.put("processLoadPercentage", operatingSystemMXBean.getProcessCpuLoad() * 100.0);
        objectValue.put("heapMemoryUsageMB", Float.valueOf((float)memoryMXBean.getHeapMemoryUsage().getUsed() / 1048576.0f));
        objectValue.put("nonHeapMemoryUsageMB", Float.valueOf((float)memoryMXBean.getNonHeapMemoryUsage().getUsed() / 1048576.0f));
        objectValue.put("peakThreadCount", threadMXBean.getPeakThreadCount());
        objectValue.put("threadCount", threadMXBean.getThreadCount());
        objectValue.put("daemonThreadCount", threadMXBean.getDaemonThreadCount());
        return objectValue;
    }
}

