/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.system;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import io.prometheus.metrics.exporter.httpserver.HTTPServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.openremote.container.util.MapAccess;
import org.openremote.manager.system.StatusResourceImpl;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.system.HealthStatusProvider;

public class HealthService
implements ContainerService {
    public static final System.Logger LOG = System.getLogger(HealthService.class.getName());
    public static final String OR_METRICS_PORT = "OR_METRICS_PORT";
    public static final int OR_METRICS_PORT_DEFAULT = 8405;
    protected List<HealthStatusProvider> healthStatusProviderList = new ArrayList<HealthStatusProvider>();
    protected boolean metricsEnabled;
    protected HTTPServer metricsServer;

    public int getPriority() {
        return 1000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(Container container) throws Exception {
        this.metricsEnabled = container.getMeterRegistry() != null;
        ServiceLoader.load(HealthStatusProvider.class).forEach(hsp -> {
            LOG.log(System.Logger.Level.INFO, "Health Status Provider: " + String.valueOf(hsp.getClass()));
            this.healthStatusProviderList.add((HealthStatusProvider)hsp);
        });
        for (HealthStatusProvider healthStatusProvider : this.healthStatusProviderList) {
            healthStatusProvider.init(container);
        }
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton(new StatusResourceImpl(container, this.healthStatusProviderList));
        if (this.metricsEnabled) {
            int metricsPort = MapAccess.getInteger((Map)container.getConfig(), (String)OR_METRICS_PORT, (int)8405);
            LOG.log(System.Logger.Level.INFO, "Metrics collection enabled");
            MeterRegistry meterRegistry = container.getMeterRegistry();
            if (!(meterRegistry instanceof PrometheusMeterRegistry)) throw new IllegalStateException("Unknown metrics meter registry implementation: " + String.valueOf(container.getMeterRegistry().getClass()));
            PrometheusMeterRegistry prometheusMeterRegistry = (PrometheusMeterRegistry)meterRegistry;
            this.metricsServer = HTTPServer.builder().port(metricsPort).registry(prometheusMeterRegistry.getPrometheusRegistry()).executorService(container.getExecutor()).buildAndStart();
            return;
        } else {
            LOG.log(System.Logger.Level.INFO, "Metrics collection disabled");
        }
    }

    public void start(Container container) throws Exception {
        for (HealthStatusProvider healthStatusProvider : this.healthStatusProviderList) {
            healthStatusProvider.start(container);
        }
    }

    public void stop(Container container) throws Exception {
        if (this.metricsServer != null) {
            this.metricsServer.close();
        }
        for (HealthStatusProvider healthStatusProvider : this.healthStatusProviderList) {
            healthStatusProvider.stop(container);
        }
    }
}

