/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.system;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.health.HealthCheck;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public interface HealthCheckResultMixin {
    @JsonSerialize(using=HealthCheckSerializer.class)
    @JsonProperty(value="type")
    public HealthCheck getCheck();

    @JsonProperty
    public HealthCheck.State getState();

    @JsonProperty
    public Optional<String> getMessage();

    @JsonProperty
    public Optional<Throwable> getError();

    @JsonProperty
    public Map<String, Object> getDetails();

    public static class HealthCheckSerializer
    extends StdScalarSerializer<HealthCheck> {
        public HealthCheckSerializer() {
            super(HealthCheck.class, false);
        }

        public void serialize(HealthCheck value, JsonGenerator g, SerializerProvider provider) throws IOException {
            g.writeString(value.getClass().getSimpleName());
        }
    }
}

